/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import jodd.lagarto.Doctype;
import jodd.lagarto.Tag;
import jodd.lagarto.TagVisitor;

public class TagVisitorChain
implements TagVisitor {
    protected final TagVisitor[] targets;

    public TagVisitorChain(TagVisitor ... targets) {
        this.targets = targets;
    }

    public void start() {
        for (TagVisitor target : this.targets) {
            target.start();
        }
    }

    public void end() {
        for (TagVisitor target : this.targets) {
            target.end();
        }
    }

    public void tag(Tag tag) {
        for (TagVisitor target : this.targets) {
            target.tag(tag);
        }
    }

    public void script(Tag tag, CharSequence body) {
        for (TagVisitor target : this.targets) {
            target.script(tag, body);
        }
    }

    public void comment(CharSequence comment) {
        for (TagVisitor target : this.targets) {
            target.comment(comment);
        }
    }

    public void text(CharSequence text) {
        for (TagVisitor target : this.targets) {
            target.text(text);
        }
    }

    public void cdata(CharSequence cdata) {
        for (TagVisitor target : this.targets) {
            target.cdata(cdata);
        }
    }

    public void xml(CharSequence version, CharSequence encoding, CharSequence standalone) {
        for (TagVisitor target : this.targets) {
            target.xml(version, encoding, standalone);
        }
    }

    public void doctype(Doctype doctype) {
        for (TagVisitor target : this.targets) {
            target.doctype(doctype);
        }
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, boolean isHiddenEndTag) {
        for (TagVisitor target : this.targets) {
            target.condComment(expression, isStartingTag, isHidden, isHiddenEndTag);
        }
    }

    public void error(String message) {
        for (TagVisitor target : this.targets) {
            target.error(message);
        }
    }
}

