/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.AcceptParser;

@ConstrainedTo(value=RuntimeType.SERVER)
@Priority(value=3000)
public class ServerContentEncodingAnnotationFilter
implements WriterInterceptor {
    @Context
    protected HttpRequest request;
    Set<String> encodings;

    public ServerContentEncodingAnnotationFilter(Set<String> encodings) {
        this.encodings = encodings;
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        List acceptEncoding = (List)this.request.getHttpHeaders().getRequestHeaders().get("Accept-Encoding");
        if (acceptEncoding != null) {
            StringBuffer buf = new StringBuffer();
            for (String accept : acceptEncoding) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(accept);
            }
            List<String> accepts = AcceptParser.parseAcceptHeader(buf.toString());
            for (String encoding : accepts) {
                if (!this.encodings.contains(encoding.toLowerCase())) continue;
                context.getHeaders().putSingle("Content-Encoding", encoding);
                break;
            }
        }
        context.proceed();
    }
}

