/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.SecureRandom;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.Base32;

public class TotpBean {
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final boolean enabled;
    private final String contextUrl;
    private final String realmName;
    private final String keyUri;
    private static final SecureRandom random = new SecureRandom();

    public TotpBean(KeycloakSession session, RealmModel realm, UserModel user, URI baseUri) {
        this.realmName = realm.getName();
        this.enabled = session.users().configuredForCredentialType(realm.getOTPPolicy().getType(), realm, user);
        this.contextUrl = baseUri.getPath();
        this.totpSecret = TotpBean.randomString(20);
        this.totpSecretEncoded = Base32.encode((byte[])this.totpSecret.getBytes());
        this.keyUri = realm.getOTPPolicy().getKeyURI(realm, this.totpSecret);
    }

    private static String randomString(int length) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVW1234567890";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(random.nextInt(chars.length()));
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.totpSecretEncoded.length(); i += 4) {
            sb.append(this.totpSecretEncoded.substring(i, i + 4 < this.totpSecretEncoded.length() ? i + 4 : this.totpSecretEncoded.length()));
            if (i + 4 >= this.totpSecretEncoded.length()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getTotpSecretQrCodeUrl() throws UnsupportedEncodingException {
        String contents = URLEncoder.encode(this.keyUri, "utf-8");
        return this.contextUrl + "qrcode" + "?size=246x246&contents=" + contents;
    }

    static {
        random.nextInt();
    }
}

