/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.token;

import java.util.Calendar;
import java.util.Date;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BasicAuthFilter;
import org.keycloak.admin.client.token.TokenService;
import org.keycloak.representations.AccessTokenResponse;

public class TokenManager {
    private AccessTokenResponse currentToken;
    private Date expirationTime;
    private Config config;

    public TokenManager(Config config) {
        this.config = config;
    }

    public String getAccessTokenString() {
        return this.getAccessToken().getToken();
    }

    public AccessTokenResponse getAccessToken() {
        if (this.currentToken == null) {
            this.grantToken();
        } else if (this.tokenExpired()) {
            this.refreshToken();
        }
        return this.currentToken;
    }

    public AccessTokenResponse grantToken() {
        ResteasyClient client = new ResteasyClientBuilder().build();
        ResteasyWebTarget target = client.target(this.config.getServerUrl());
        Form form = new Form().param("username", this.config.getUsername()).param("password", this.config.getPassword());
        if (this.config.isPublicClient()) {
            form.param("client_id", this.config.getClientId());
        } else {
            target.register((Object)new BasicAuthFilter(this.config.getClientId(), this.config.getClientSecret()));
        }
        TokenService tokenService = (TokenService)target.proxy(TokenService.class);
        AccessTokenResponse response = tokenService.grantToken(this.config.getRealm(), (MultivaluedMap<String, String>)form.asMap());
        this.defineCurrentToken(response);
        return response;
    }

    public AccessTokenResponse refreshToken() {
        ResteasyClient client = new ResteasyClientBuilder().build();
        ResteasyWebTarget target = client.target(this.config.getServerUrl());
        Form form = new Form().param("username", this.config.getUsername()).param("password", this.config.getPassword());
        if (this.config.isPublicClient()) {
            form.param("client_id", this.config.getClientId());
        } else {
            target.register((Object)new BasicAuthFilter(this.config.getClientId(), this.config.getClientSecret()));
        }
        TokenService tokenService = (TokenService)target.proxy(TokenService.class);
        AccessTokenResponse response = tokenService.refreshToken(this.config.getRealm(), (MultivaluedMap<String, String>)form.asMap());
        this.defineCurrentToken(response);
        return response;
    }

    private void setExpirationTime() {
        Calendar cal = Calendar.getInstance();
        cal.add(13, (int)this.currentToken.getExpiresIn());
        this.expirationTime = cal.getTime();
    }

    private boolean tokenExpired() {
        return new Date().after(this.expirationTime);
    }

    private void defineCurrentToken(AccessTokenResponse accessTokenResponse) {
        this.currentToken = accessTokenResponse;
        this.setExpirationTime();
    }
}

