/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.Keycloak;

public class KeycloakBuilder {
    private String serverUrl;
    private String realm;
    private String username;
    private String password;
    private String clientId;
    private String clientSecret;
    private String grantType;
    private ResteasyClient resteasyClient;
    private String authorization;

    public KeycloakBuilder serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public KeycloakBuilder realm(String realm) {
        this.realm = realm;
        return this;
    }

    public KeycloakBuilder grantType(String grantType) {
        Config.checkGrantType(grantType);
        this.grantType = grantType;
        return this;
    }

    public KeycloakBuilder username(String username) {
        this.username = username;
        return this;
    }

    public KeycloakBuilder password(String password) {
        this.password = password;
        return this;
    }

    public KeycloakBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public KeycloakBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public KeycloakBuilder resteasyClient(ResteasyClient resteasyClient) {
        this.resteasyClient = resteasyClient;
        return this;
    }

    public KeycloakBuilder authorization(String auth) {
        this.authorization = auth;
        return this;
    }

    public Keycloak build() {
        if (this.serverUrl == null) {
            throw new IllegalStateException("serverUrl required");
        }
        if (this.realm == null) {
            throw new IllegalStateException("realm required");
        }
        if (this.authorization == null && this.grantType == null) {
            this.grantType = "password";
        }
        if ("password".equals(this.grantType)) {
            if (this.username == null) {
                throw new IllegalStateException("username required");
            }
            if (this.password == null) {
                throw new IllegalStateException("password required");
            }
        } else if ("client_credentials".equals(this.grantType) && this.clientSecret == null) {
            throw new IllegalStateException("clientSecret required with grant_type=client_credentials");
        }
        if (this.authorization == null && this.clientId == null) {
            throw new IllegalStateException("clientId required");
        }
        return new Keycloak(this.serverUrl, this.realm, this.username, this.password, this.clientId, this.clientSecret, this.grantType, this.resteasyClient, this.authorization);
    }

    private KeycloakBuilder() {
    }

    public static KeycloakBuilder builder() {
        return new KeycloakBuilder();
    }
}

