/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.tomcat.AbstractKeycloakAuthenticatorValve;
import org.keycloak.adapters.tomcat.CatalinaAdapterSessionStore;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;

public class CatalinaSessionTokenStore
extends CatalinaAdapterSessionStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger("" + CatalinaSessionTokenStore.class);
    private KeycloakDeployment deployment;
    private CatalinaUserSessionManagement sessionManagement;
    protected GenericPrincipalFactory principalFactory;

    public CatalinaSessionTokenStore(Request request, KeycloakDeployment deployment, CatalinaUserSessionManagement sessionManagement, GenericPrincipalFactory principalFactory, AbstractKeycloakAuthenticatorValve valve) {
        super(request, valve);
        this.deployment = deployment;
        this.sessionManagement = sessionManagement;
        this.principalFactory = principalFactory;
    }

    public void checkCurrentToken() {
        Session catalinaSession = this.request.getSessionInternal(false);
        if (catalinaSession == null) {
            return;
        }
        SerializableKeycloakAccount account = (SerializableKeycloakAccount)catalinaSession.getSession().getAttribute(SerializableKeycloakAccount.class.getName());
        if (account == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = account.getKeycloakSecurityContext();
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        }
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return;
        }
        log.fine("Cleanup and expire session " + catalinaSession.getId() + " after failed refresh");
        this.request.setUserPrincipal(null);
        this.request.setAuthType(null);
        this.cleanSession(catalinaSession);
        catalinaSession.expire();
    }

    protected void cleanSession(Session catalinaSession) {
        catalinaSession.getSession().removeAttribute(OidcKeycloakAccount.class.getName());
        catalinaSession.setPrincipal(null);
        catalinaSession.setAuthType(null);
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        Session session = this.request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SerializableKeycloakAccount account = (SerializableKeycloakAccount)session.getSession().getAttribute(SerializableKeycloakAccount.class.getName());
        if (account == null) {
            return false;
        }
        log.fine("remote logged in already. Establish state from session");
        RefreshableKeycloakSecurityContext securityContext = account.getKeycloakSecurityContext();
        if (!this.deployment.getRealm().equals(securityContext.getRealm())) {
            log.fine("Account from cookie is from a different realm than for the request.");
            this.cleanSession(session);
            return false;
        }
        securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), account.getPrincipal(), account.getRoles());
            session.setPrincipal((Principal)principal);
            session.setAuthType("KEYCLOAK");
        }
        this.request.setUserPrincipal((Principal)principal);
        this.request.setAuthType("KEYCLOAK");
        this.restoreRequest();
        return true;
    }

    public void saveAccountInfo(OidcKeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        Set roles = account.getRoles();
        GenericPrincipal principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), account.getPrincipal(), roles);
        SerializableKeycloakAccount sAccount = new SerializableKeycloakAccount(roles, account.getPrincipal(), securityContext);
        Session session = this.request.getSessionInternal(true);
        session.setPrincipal((Principal)principal);
        session.setAuthType("KEYCLOAK");
        session.getSession().setAttribute(SerializableKeycloakAccount.class.getName(), (Object)sAccount);
        String username = securityContext.getToken().getSubject();
        log.fine("userSessionManagement.login: " + username);
        this.sessionManagement.login(session);
    }

    public void logout() {
        Session session = this.request.getSessionInternal(false);
        if (session != null) {
            this.cleanSession(session);
        }
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }

    public static class SerializableKeycloakAccount
    implements OidcKeycloakAccount,
    Serializable {
        protected Set<String> roles;
        protected Principal principal;
        protected RefreshableKeycloakSecurityContext securityContext;

        public SerializableKeycloakAccount(Set<String> roles, Principal principal, RefreshableKeycloakSecurityContext securityContext) {
            this.roles = roles;
            this.principal = principal;
            this.securityContext = securityContext;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
            return this.securityContext;
        }
    }
}

