/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo;

import com.mongodb.MongoException;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.connections.mongo.impl.MongoStoreImpl;
import org.keycloak.models.KeycloakTransaction;

public class MongoKeycloakTransaction
implements KeycloakTransaction {
    private final MongoStoreInvocationContext invocationContext;
    private boolean started = false;
    private boolean rollbackOnly = false;

    public MongoKeycloakTransaction(MongoStoreInvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    public void begin() {
        if (this.started) {
            throw new IllegalStateException("Transaction already started");
        }
        this.started = true;
        this.invocationContext.begin();
    }

    public void commit() {
        if (!this.started) {
            throw new IllegalStateException("Transaction not yet started");
        }
        if (this.rollbackOnly) {
            throw new IllegalStateException("Can't commit as transaction marked for rollback");
        }
        try {
            this.invocationContext.commit();
        }
        catch (MongoException e) {
            throw MongoStoreImpl.convertException(e);
        }
        this.started = false;
    }

    public void rollback() {
        this.invocationContext.rollback();
        this.started = false;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public boolean isActive() {
        return this.started;
    }
}

