/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.zip;

import java.io.File;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ExportProviderFactory;
import org.keycloak.exportimport.zip.ZipExportProvider;
import org.keycloak.models.KeycloakSession;

public class ZipExportProviderFactory
implements ExportProviderFactory {
    public static final String PROVIDER_ID = "zip";

    public ExportProvider create(KeycloakSession session) {
        String fileName = ExportImportConfig.getZipFile();
        String password = ExportImportConfig.getZipPassword();
        if (fileName == null) {
            throw new IllegalArgumentException("ZIP file for export not provided");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password for encrypting ZIP not provided");
        }
        return new ZipExportProvider(new File(fileName), password);
    }

    public void init(Config.Scope config) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

