/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.jetty.Jetty93RequestAuthenticator;
import org.keycloak.adapters.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.jetty.core.AbstractKeycloakJettyAuthenticator;
import org.keycloak.adapters.jetty.core.JettyRequestAuthenticator;
import org.keycloak.adapters.jetty.core.JettySessionTokenStore;
import org.keycloak.adapters.jetty.spi.JettyHttpFacade;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;

public class KeycloakJettyAuthenticator
extends AbstractKeycloakJettyAuthenticator {
    protected Request resolveRequest(ServletRequest req) {
        return Request.getBaseRequest((ServletRequest)req);
    }

    protected Authentication createAuthentication(UserIdentity userIdentity, final Request request) {
        return new AbstractKeycloakJettyAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public void logout() {
                KeycloakJettyAuthenticator.this.logoutCurrent(request);
            }
        };
    }

    public AdapterTokenStore createSessionTokenStore(Request request, KeycloakDeployment resolvedDeployment) {
        return new JettySessionTokenStore(request, resolvedDeployment, (AdapterSessionStore)new JettyAdapterSessionStore(request));
    }

    protected JettyRequestAuthenticator createRequestAuthenticator(Request request, JettyHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        return new Jetty93RequestAuthenticator((HttpFacade)facade, deployment, tokenStore, -1, request);
    }
}

