/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.locking;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProviderFactory;

public class LockingConnectionProviderFactory
extends DefaultInfinispanConnectionProviderFactory {
    public static final String VERSION_CACHE_NAME = "realmVersions";
    protected static final Logger logger = Logger.getLogger(LockingConnectionProviderFactory.class);

    @Override
    public String getId() {
        return "locking";
    }

    @Override
    protected void initEmbedded() {
        super.initEmbedded();
        ConfigurationBuilder counterConfigBuilder = new ConfigurationBuilder();
        counterConfigBuilder.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        counterConfigBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        counterConfigBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        Configuration counterCacheConfiguration = counterConfigBuilder.build();
        this.cacheManager.defineConfiguration(VERSION_CACHE_NAME, counterCacheConfiguration);
    }
}

