/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.locking;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedClientTemplate;
import org.keycloak.models.cache.entities.CachedGroup;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRole;
import org.keycloak.models.cache.infinispan.locking.Revisioned;
import org.keycloak.models.cache.infinispan.locking.UpdateCounter;

public class LockingRealmCache
implements RealmCache {
    protected static final Logger logger = Logger.getLogger(LockingRealmCache.class);
    protected final Cache<String, Long> revisions;
    protected final Cache<String, Object> cache;
    protected final ConcurrentHashMap<String, String> realmLookup = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> clientLookup = new ConcurrentHashMap();

    public LockingRealmCache(Cache<String, Object> cache, Cache<String, Long> revisions) {
        this.cache = cache;
        this.revisions = revisions;
    }

    public Cache<String, Object> getCache() {
        return this.cache;
    }

    public Cache<String, Long> getRevisions() {
        return this.revisions;
    }

    public ConcurrentHashMap<String, String> getRealmLookup() {
        return this.realmLookup;
    }

    public ConcurrentHashMap<String, String> getClientLookup() {
        return this.clientLookup;
    }

    public Long getCurrentRevision(String id) {
        return (Long)this.revisions.get((Object)id);
    }

    public void endRevisionBatch() {
        try {
            this.revisions.endBatch(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <T> T get(String id, Class<T> type) {
        long oRev;
        Revisioned o = (Revisioned)this.cache.get((Object)id);
        if (o == null) {
            return null;
        }
        Long rev = (Long)this.revisions.get((Object)id);
        if (rev == null) {
            logger.tracev("get() missing rev", new Object[0]);
            return null;
        }
        long l = oRev = o.getRevision() == null ? -1L : o.getRevision();
        if (rev > oRev) {
            logger.tracev("get() rev: {0} o.rev: {1}", (Object)rev, (Object)oRev);
            return null;
        }
        return o != null && type.isInstance(o) ? (T)type.cast(o) : null;
    }

    protected Object invalidateObject(String id) {
        Object removed = this.cache.remove((Object)id);
        this.revisions.put((Object)id, (Object)UpdateCounter.next());
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRevisioned(String id, Revisioned object) {
        try {
            Long rev = (Long)this.revisions.get((Object)id);
            if (rev == null) {
                rev = UpdateCounter.current();
                this.revisions.put((Object)id, (Object)rev);
            }
            this.revisions.startBatch();
            if (!this.revisions.getAdvancedCache().lock((Object[])new String[]{id})) {
                logger.trace((Object)"Could not obtain version lock");
            }
            if ((rev = (Long)this.revisions.get((Object)id)) == null) {
                return;
            }
            if (rev.equals(object.getRevision())) {
                this.cache.putForExternalRead((Object)id, (Object)object);
                return;
            }
            if (rev > object.getRevision()) {
                return;
            }
            this.revisions.put((Object)id, (Object)object.getRevision());
            this.cache.putForExternalRead((Object)id, (Object)object);
        }
        finally {
            this.endRevisionBatch();
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public CachedRealm getRealm(String id) {
        return this.get(id, CachedRealm.class);
    }

    public void invalidateRealm(CachedRealm realm) {
        logger.tracev("Invalidating realm {0}", (Object)realm.getId());
        this.invalidateObject(realm.getId());
        this.realmLookup.remove(realm.getName());
    }

    public void invalidateRealmById(String id) {
        CachedRealm cached = (CachedRealm)this.invalidateObject(id);
        if (cached != null) {
            this.realmLookup.remove(cached.getName());
        }
    }

    public void addRealm(CachedRealm realm) {
        logger.tracev("Adding realm {0}", (Object)realm.getId());
        this.addRevisioned(realm.getId(), (Revisioned)realm);
        this.realmLookup.put(realm.getName(), realm.getId());
    }

    public CachedRealm getRealmByName(String name) {
        String id = this.realmLookup.get(name);
        return id != null ? this.getRealm(id) : null;
    }

    public CachedClient getClient(String id) {
        return this.get(id, CachedClient.class);
    }

    public CachedClient getClientByClientId(RealmModel realm, String clientId) {
        String id = this.clientLookup.get(realm.getId() + "." + clientId);
        return id != null ? this.getClient(id) : null;
    }

    public void invalidateClient(CachedClient app) {
        logger.tracev("Removing application {0}", (Object)app.getId());
        this.invalidateObject(app.getId());
        this.clientLookup.remove(this.getClientIdKey(app));
    }

    public void addClient(CachedClient app) {
        logger.tracev("Adding application {0}", (Object)app.getId());
        this.addRevisioned(app.getId(), (Revisioned)app);
        this.clientLookup.put(this.getClientIdKey(app), app.getId());
    }

    public void invalidateClientById(String id) {
        CachedClient client = (CachedClient)this.invalidateObject(id);
        if (client != null) {
            logger.tracev("Removing application {0}", (Object)client.getClientId());
            this.clientLookup.remove(this.getClientIdKey(client));
        }
    }

    protected String getClientIdKey(CachedClient client) {
        return client.getRealm() + "." + client.getClientId();
    }

    public void evictClientById(String id) {
        logger.tracev("Evicting application {0}", (Object)id);
        this.cache.evict((Object)id);
    }

    public CachedGroup getGroup(String id) {
        return this.get(id, CachedGroup.class);
    }

    public void invalidateGroup(CachedGroup role) {
        logger.tracev("Removing group {0}", (Object)role.getId());
        this.invalidateObject(role.getId());
    }

    public void addGroup(CachedGroup role) {
        logger.tracev("Adding group {0}", (Object)role.getId());
        this.addRevisioned(role.getId(), (Revisioned)role);
    }

    public void invalidateGroupById(String id) {
        logger.tracev("Removing group {0}", (Object)id);
        this.invalidateObject(id);
    }

    public CachedRole getRole(String id) {
        return this.get(id, CachedRole.class);
    }

    public void invalidateRole(CachedRole role) {
        logger.tracev("Removing role {0}", (Object)role.getId());
        this.invalidateObject(role.getId());
    }

    public void invalidateRoleById(String id) {
        logger.tracev("Removing role {0}", (Object)id);
        this.invalidateObject(id);
    }

    public void evictRoleById(String id) {
        logger.tracev("Evicting role {0}", (Object)id);
        this.cache.evict((Object)id);
    }

    public void addRole(CachedRole role) {
        logger.tracev("Adding role {0}", (Object)role.getId());
        this.addRevisioned(role.getId(), (Revisioned)role);
    }

    public CachedClientTemplate getClientTemplate(String id) {
        return this.get(id, CachedClientTemplate.class);
    }

    public void invalidateClientTemplate(CachedClientTemplate app) {
        logger.tracev("Removing client template {0}", (Object)app.getId());
        this.invalidateObject(app.getId());
    }

    public void addClientTemplate(CachedClientTemplate app) {
        logger.tracev("Adding client template {0}", (Object)app.getId());
        this.addRevisioned(app.getId(), (Revisioned)app);
    }

    public void invalidateClientTemplateById(String id) {
        logger.tracev("Removing client template {0}", (Object)id);
        this.invalidateObject(id);
    }

    public void evictClientTemplateById(String id) {
        logger.tracev("Evicting client template {0}", (Object)id);
        this.cache.evict((Object)id);
    }
}

