/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.locking.entities;

import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.infinispan.locking.Revisioned;

public class RevisionedCachedRealm
extends CachedRealm
implements Revisioned {
    private Long revision;

    public RevisionedCachedRealm(Long revision, RealmCache cache, RealmProvider delegate, RealmModel model) {
        super(cache, delegate, model);
        this.revision = revision;
    }

    @Override
    public Long getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(Long revision) {
        this.revision = revision;
    }

    protected void cacheClientTemplates(RealmCache cache, RealmProvider delegate, RealmModel model) {
        for (ClientTemplateModel template : model.getClientTemplates()) {
            this.clientTemplates.add(template.getId());
        }
    }

    protected void cacheClients(RealmCache cache, RealmProvider delegate, RealmModel model) {
        for (ClientModel client : model.getClients()) {
            this.clients.add(client.getId());
        }
    }

    protected void cacheRealmRoles(RealmCache cache, RealmModel model) {
        for (RoleModel role : model.getRoles()) {
            this.realmRoles.put(role.getName(), role.getId());
        }
    }
}

