/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Map;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshEvent;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;
import org.keycloak.models.utils.KeycloakModelUtils;

public class LastSessionRefreshListener
implements ClusterListener {
    public static final Logger logger = Logger.getLogger(LastSessionRefreshListener.class);
    public static final String IGNORE_REMOTE_CACHE_UPDATE = "IGNORE_REMOTE_CACHE_UPDATE";
    private final boolean offline;
    private final KeycloakSessionFactory sessionFactory;
    private final Cache<String, SessionEntityWrapper> cache;
    private final boolean distributed;
    private final String myAddress;

    public LastSessionRefreshListener(KeycloakSession session, Cache<String, SessionEntityWrapper> cache, boolean offline) {
        this.sessionFactory = session.getKeycloakSessionFactory();
        this.cache = cache;
        this.offline = offline;
        this.distributed = InfinispanUtil.isDistributedCache(cache);
        this.myAddress = this.distributed ? InfinispanUtil.getMyAddress(session) : null;
    }

    public void eventReceived(ClusterEvent event) {
        Map<String, SessionData> lastSessionRefreshes = ((LastSessionRefreshEvent)event).getLastSessionRefreshes();
        if (logger.isDebugEnabled()) {
            logger.debugf("Received refreshes. Offline %b, refreshes: %s", (Object)this.offline, lastSessionRefreshes);
        }
        lastSessionRefreshes.entrySet().stream().forEach(entry -> {
            String sessionId = (String)entry.getKey();
            String realmId = ((SessionData)entry.getValue()).getRealmId();
            int lastSessionRefresh = ((SessionData)entry.getValue()).getLastSessionRefresh();
            if (this.shouldUpdateLocalCache(sessionId)) {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, kcSession -> {
                    RealmModel realm = kcSession.realms().getRealm(realmId);
                    UserSessionModel userSession = kcSession.sessions().getUserSession(realm, sessionId);
                    if (userSession == null) {
                        logger.debugf("User session %s not available on node %s", (Object)sessionId, (Object)this.myAddress);
                    } else if (lastSessionRefresh > userSession.getLastSessionRefresh()) {
                        kcSession.setAttribute(IGNORE_REMOTE_CACHE_UPDATE, (Object)true);
                        userSession.setLastSessionRefresh(lastSessionRefresh);
                    }
                });
            }
        });
    }

    protected boolean shouldUpdateLocalCache(String key) {
        if (!this.distributed) {
            return true;
        }
        String keyAddress = InfinispanUtil.getKeyPrimaryOwnerAddress(this.cache, key);
        return this.myAddress.equals(keyAddress);
    }
}

