/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.cluster.infinispan.CrossDCAwareCacheFactory;
import org.keycloak.cluster.infinispan.InfinispanNotificationsManager;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.cluster.infinispan.TaskCallback;
import org.keycloak.common.util.Time;

public class InfinispanClusterProvider
implements ClusterProvider {
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProvider.class);
    public static final String CLUSTER_STARTUP_TIME_KEY = "cluster-start-time";
    private static final String TASK_KEY_PREFIX = "task::";
    private final int clusterStartupTime;
    private final String myAddress;
    private final CrossDCAwareCacheFactory crossDCAwareCacheFactory;
    private final InfinispanNotificationsManager notificationsManager;
    private final ExecutorService localExecutor;

    public InfinispanClusterProvider(int clusterStartupTime, String myAddress, CrossDCAwareCacheFactory crossDCAwareCacheFactory, InfinispanNotificationsManager notificationsManager, ExecutorService localExecutor) {
        this.myAddress = myAddress;
        this.clusterStartupTime = clusterStartupTime;
        this.crossDCAwareCacheFactory = crossDCAwareCacheFactory;
        this.notificationsManager = notificationsManager;
        this.localExecutor = localExecutor;
    }

    public int getClusterStartupTime() {
        return this.clusterStartupTime;
    }

    public void close() {
    }

    public <T> ExecutionResult<T> executeIfNotExecuted(String taskKey, int taskTimeoutInSeconds, Callable<T> task) {
        String cacheKey = TASK_KEY_PREFIX + taskKey;
        boolean locked = this.tryLock(cacheKey, taskTimeoutInSeconds);
        if (locked) {
            try {
                T result = task.call();
                ExecutionResult executionResult = ExecutionResult.executed(result);
                return executionResult;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception when executed task " + taskKey, e);
            }
            finally {
                this.removeFromCache(cacheKey);
            }
        }
        return ExecutionResult.notExecuted();
    }

    public Future<Boolean> executeIfNotExecutedAsync(String taskKey, int taskTimeoutInSeconds, Callable task) {
        TaskCallback newCallback = new TaskCallback();
        TaskCallback callback = this.notificationsManager.registerTaskCallback(TASK_KEY_PREFIX + taskKey, newCallback);
        if (newCallback == callback) {
            Callable<Boolean> wrappedTask = () -> {
                boolean executed = this.executeIfNotExecuted(taskKey, taskTimeoutInSeconds, task).isExecuted();
                if (!executed) {
                    logger.infof("Task already in progress on other cluster node. Will wait until it's finished", new Object[0]);
                }
                callback.getTaskCompletedLatch().await(taskTimeoutInSeconds, TimeUnit.SECONDS);
                return callback.isSuccess();
            };
            Future<Boolean> future = this.localExecutor.submit(wrappedTask);
            callback.setFuture(future);
        } else {
            logger.infof("Task already in progress on this cluster node. Will wait until it's finished", new Object[0]);
        }
        return callback.getFuture();
    }

    public void registerListener(String taskKey, ClusterListener task) {
        this.notificationsManager.registerListener(taskKey, task);
    }

    public void notify(String taskKey, ClusterEvent event, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        this.notificationsManager.notify(taskKey, event, ignoreSender, dcNotify);
    }

    private LockEntry createLockEntry() {
        LockEntry lock = new LockEntry();
        lock.setNode(this.myAddress);
        lock.setTimestamp(Time.currentTime());
        return lock;
    }

    private boolean tryLock(String cacheKey, int taskTimeoutInSeconds) {
        LockEntry myLock = this.createLockEntry();
        LockEntry existingLock = (LockEntry)this.crossDCAwareCacheFactory.getCache().putIfAbsent((Object)cacheKey, (Object)myLock, (long)taskTimeoutInSeconds, TimeUnit.SECONDS);
        if (existingLock != null) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Task %s in progress already by node %s. Ignoring task.", (Object)cacheKey, (Object)existingLock.getNode());
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Successfully acquired lock for task %s. Our node is %s", (Object)cacheKey, (Object)myLock.getNode());
        }
        return true;
    }

    private void removeFromCache(String cacheKey) {
        int retry = 3;
        while (true) {
            try {
                this.crossDCAwareCacheFactory.getCache().remove((Object)cacheKey);
                if (logger.isTraceEnabled()) {
                    logger.tracef("Task %s removed from the cache", (Object)cacheKey);
                }
                return;
            }
            catch (RuntimeException e) {
                if (--retry != 0) continue;
                throw e;
            }
            break;
        }
    }
}

