/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.models.CodeToTokenStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanCodeToTokenStoreProvider
implements CodeToTokenStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanCodeToTokenStoreProvider.class);
    private final Supplier<BasicCache<UUID, ActionTokenValueEntity>> codeCache;
    private final KeycloakSession session;

    public InfinispanCodeToTokenStoreProvider(KeycloakSession session, Supplier<BasicCache<UUID, ActionTokenValueEntity>> actionKeyCache) {
        this.session = session;
        this.codeCache = actionKeyCache;
    }

    public boolean putIfAbsent(UUID codeId) {
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(null);
        int lifespanInSeconds = this.session.getContext().getRealm().getAccessCodeLifespan();
        try {
            BasicCache<UUID, ActionTokenValueEntity> cache = this.codeCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.putIfAbsent((Object)codeId, (Object)tokenValue, (long)lifespanInSeconds, TimeUnit.SECONDS);
            return existing == null;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding code %s", (Object)codeId);
            }
            return false;
        }
    }

    public void close() {
    }
}

