/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class RemoteCacheSessionsLoader
implements SessionLoader {
    private static final Logger log = Logger.getLogger(RemoteCacheSessionsLoader.class);
    private static final String REMOTE_SCRIPT_FOR_LOAD_SESSIONS = "function loadSessions() {  var flagClazz = cache.getClass().getClassLoader().loadClass(\"org.infinispan.context.Flag\"); \n  var localFlag = java.lang.Enum.valueOf(flagClazz, \"CACHE_MODE_LOCAL\"); \n  var cacheMode = cache.getCacheConfiguration().clustering().cacheMode(); \n  var canUseLocalFlag = !cacheMode.isClustered() || cacheMode.isReplicated(); \n  var cacheStream; \n  if (canUseLocalFlag) { \n      cacheStream = cache.getAdvancedCache().withFlags([ localFlag ]).entrySet().stream();\n  } else { \n      cacheStream = cache.getAdvancedCache().withFlags([ ]).entrySet().stream();\n  }; \n  var result = cacheStream.skip(first).limit(max).collect(java.util.stream.Collectors.toMap(\n    new java.util.function.Function() {\n      apply: function(entry) {\n        return entry.getKey();\n      }\n    },\n    new java.util.function.Function() {\n      apply: function(entry) {\n        return entry.getValue();\n      }\n    }\n  ));\n\n  cacheStream.close();\n  return result;\n};\n\nloadSessions();";
    private final String cacheName;

    public RemoteCacheSessionsLoader(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public void init(KeycloakSession session) {
        RemoteCache remoteCache = this.getRemoteCache(session);
        RemoteCache scriptCache = remoteCache.getRemoteCacheManager().getCache("___script_cache");
        if (!scriptCache.containsKey((Object)"load-sessions.js")) {
            scriptCache.put((Object)"load-sessions.js", (Object)"// mode=local,language=javascript\nfunction loadSessions() {  var flagClazz = cache.getClass().getClassLoader().loadClass(\"org.infinispan.context.Flag\"); \n  var localFlag = java.lang.Enum.valueOf(flagClazz, \"CACHE_MODE_LOCAL\"); \n  var cacheMode = cache.getCacheConfiguration().clustering().cacheMode(); \n  var canUseLocalFlag = !cacheMode.isClustered() || cacheMode.isReplicated(); \n  var cacheStream; \n  if (canUseLocalFlag) { \n      cacheStream = cache.getAdvancedCache().withFlags([ localFlag ]).entrySet().stream();\n  } else { \n      cacheStream = cache.getAdvancedCache().withFlags([ ]).entrySet().stream();\n  }; \n  var result = cacheStream.skip(first).limit(max).collect(java.util.stream.Collectors.toMap(\n    new java.util.function.Function() {\n      apply: function(entry) {\n        return entry.getKey();\n      }\n    },\n    new java.util.function.Function() {\n      apply: function(entry) {\n        return entry.getValue();\n      }\n    }\n  ));\n\n  cacheStream.close();\n  return result;\n};\n\nloadSessions();");
        }
    }

    @Override
    public int getSessionsCount(KeycloakSession session) {
        RemoteCache remoteCache = this.getRemoteCache(session);
        return remoteCache.size();
    }

    @Override
    public boolean loadSessions(KeycloakSession session, int first, int max) {
        Cache cache = this.getCache(session);
        AdvancedCache decoratedCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE, Flag.IGNORE_RETURN_VALUES});
        RemoteCache remoteCache = this.getRemoteCache(session);
        log.debugf("Will do bulk load of sessions from remote cache '%s' . First: %d, max: %d", (Object)cache.getName(), (Object)first, (Object)max);
        HashMap<String, Integer> remoteParams = new HashMap<String, Integer>();
        remoteParams.put("first", first);
        remoteParams.put("max", max);
        Map remoteObjects = (Map)remoteCache.execute("load-sessions.js", remoteParams);
        log.debugf("Successfully finished loading sessions '%s' . First: %d, max: %d", (Object)cache.getName(), (Object)first, (Object)max);
        Marshaller marshaller = remoteCache.getRemoteCacheManager().getMarshaller();
        for (Map.Entry entry : remoteObjects.entrySet()) {
            try {
                Object key = marshaller.objectFromByteBuffer((byte[])entry.getKey());
                SessionEntityWrapper entityWrapper = (SessionEntityWrapper)marshaller.objectFromByteBuffer((byte[])entry.getValue());
                decoratedCache.putAsync(key, (Object)entityWrapper);
            }
            catch (Exception e) {
                log.warn((Object)"Error loading session from remote cache", (Throwable)e);
            }
        }
        return true;
    }

    private Cache getCache(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        return ispn.getCache(this.cacheName);
    }

    @Override
    public boolean isFinished(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Boolean sessionsLoaded = (Boolean)workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}).get((Object)"PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC");
        if ((this.cacheName.equals("offlineSessions") || this.cacheName.equals("offlineClientSessions")) && sessionsLoaded != null && sessionsLoaded.booleanValue()) {
            log.debugf("Sessions already loaded in current DC. Skip sessions loading from remote cache '%s'", (Object)this.cacheName);
            return true;
        }
        log.debugf("Sessions maybe not yet loaded in current DC. Will load them from remote cache '%s'", (Object)this.cacheName);
        return false;
    }

    @Override
    public void afterAllSessionsLoaded(BaseCacheInitializer initializer) {
    }

    private RemoteCache getRemoteCache(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        return ispn.getRemoteCache(this.cacheName);
    }
}

