/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.AuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RootAuthenticationSessionAdapter
implements RootAuthenticationSessionModel {
    private KeycloakSession session;
    private InfinispanAuthenticationSessionProvider provider;
    private Cache<String, RootAuthenticationSessionEntity> cache;
    private RealmModel realm;
    private RootAuthenticationSessionEntity entity;

    public RootAuthenticationSessionAdapter(KeycloakSession session, InfinispanAuthenticationSessionProvider provider, Cache<String, RootAuthenticationSessionEntity> cache, RealmModel realm, RootAuthenticationSessionEntity entity) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
    }

    void update() {
        this.provider.tx.replace(this.cache, this.entity.getId(), this.entity);
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
        this.update();
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        HashMap<String, AuthenticationSessionModel> result = new HashMap<String, AuthenticationSessionModel>();
        for (Map.Entry<String, AuthenticationSessionEntity> entry : this.entity.getAuthenticationSessions().entrySet()) {
            String tabId = entry.getKey();
            result.put(tabId, new AuthenticationSessionAdapter(this.session, this, tabId, entry.getValue()));
        }
        return result;
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        AuthenticationSessionModel authSession = this.getAuthenticationSessions().get(tabId);
        if (authSession != null && client.equals(authSession.getClient())) {
            return authSession;
        }
        return null;
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        AuthenticationSessionEntity authSessionEntity = new AuthenticationSessionEntity();
        authSessionEntity.setClientUUID(client.getId());
        String tabId = this.provider.generateTabId();
        this.entity.getAuthenticationSessions().put(tabId, authSessionEntity);
        this.entity.setTimestamp(Time.currentTime());
        this.update();
        return new AuthenticationSessionAdapter(this.session, this, tabId, authSessionEntity);
    }

    public void restartSession(RealmModel realm) {
        this.entity.getAuthenticationSessions().clear();
        this.entity.setTimestamp(Time.currentTime());
        this.update();
    }
}

