/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.keycloak.models.RealmModel;
import org.picketbox.test.ldap.AbstractLDAPTest;

public class LDAPEmbeddedServer
extends AbstractLDAPTest {
    public static final String BASE_DN = "dc=keycloak,dc=org";
    public static final String LDAP_URL = "ldap://localhost:10389";
    public static final String ROLES_DN_SUFFIX = "ou=Roles,dc=keycloak,dc=org";
    public static final String GROUP_DN_SUFFIX = "ou=Groups,dc=keycloak,dc=org";
    public static final String USER_DN_SUFFIX = "ou=People,dc=keycloak,dc=org";
    public static final String AGENT_DN_SUFFIX = "ou=Agent,dc=keycloak,dc=org";
    public static final String CUSTOM_ACCOUNT_DN_SUFFIX = "ou=CustomAccount,dc=keycloak,dc=org";
    public static final String CONNECTION_PROPERTIES = "ldap/ldap-connection.properties";
    protected String connectionUrl = "ldap://localhost:10389";
    protected String baseDn = "dc=keycloak,dc=org";
    protected String userDnSuffix = "ou=People,dc=keycloak,dc=org";
    protected String rolesDnSuffix = "ou=Roles,dc=keycloak,dc=org";
    protected String groupDnSuffix = "ou=Groups,dc=keycloak,dc=org";
    protected String agentDnSuffix = "ou=Agent,dc=keycloak,dc=org";
    protected boolean startEmbeddedLdapLerver = true;
    protected String bindDn = "uid=admin,ou=system";
    protected String bindCredential = "secret";
    public static String IDM_TEST_LDAP_CONNECTION_URL = "idm.test.ldap.connection.url";
    public static String IDM_TEST_LDAP_BASE_DN = "idm.test.ldap.base.dn";
    public static String IDM_TEST_LDAP_ROLES_DN_SUFFIX = "idm.test.ldap.roles.dn.suffix";
    public static String IDM_TEST_LDAP_GROUP_DN_SUFFIX = "idm.test.ldap.group.dn.suffix";
    public static String IDM_TEST_LDAP_USER_DN_SUFFIX = "idm.test.ldap.user.dn.suffix";
    public static String IDM_TEST_LDAP_AGENT_DN_SUFFIX = "idm.test.ldap.agent.dn.suffix";
    public static String IDM_TEST_LDAP_START_EMBEDDED_LDAP_SERVER = "idm.test.ldap.start.embedded.ldap.server";
    public static String IDM_TEST_LDAP_BIND_DN = "idm.test.ldap.bind.dn";
    public static String IDM_TEST_LDAP_BIND_CREDENTIAL = "idm.test.ldap.bind.credential";

    public LDAPEmbeddedServer() {
        this.loadConnectionProperties();
    }

    protected void loadConnectionProperties() {
        Properties p = new Properties();
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONNECTION_PROPERTIES);
            p.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.connectionUrl = p.getProperty(IDM_TEST_LDAP_CONNECTION_URL, LDAP_URL);
        this.baseDn = p.getProperty(IDM_TEST_LDAP_BASE_DN, BASE_DN);
        this.userDnSuffix = p.getProperty(IDM_TEST_LDAP_USER_DN_SUFFIX, USER_DN_SUFFIX);
        this.rolesDnSuffix = p.getProperty(IDM_TEST_LDAP_ROLES_DN_SUFFIX, ROLES_DN_SUFFIX);
        this.groupDnSuffix = p.getProperty(IDM_TEST_LDAP_GROUP_DN_SUFFIX, GROUP_DN_SUFFIX);
        this.agentDnSuffix = p.getProperty(IDM_TEST_LDAP_AGENT_DN_SUFFIX, AGENT_DN_SUFFIX);
        this.startEmbeddedLdapLerver = Boolean.parseBoolean(p.getProperty(IDM_TEST_LDAP_START_EMBEDDED_LDAP_SERVER, "true"));
        this.bindDn = p.getProperty(IDM_TEST_LDAP_BIND_DN, this.bindDn);
        this.bindCredential = p.getProperty(IDM_TEST_LDAP_BIND_CREDENTIAL, this.bindCredential);
    }

    public void setup() throws Exception {
        if (this.isStartEmbeddedLdapLerver()) {
            String tempDir = System.getProperty("java.io.tmpdir");
            File workDir = new File(tempDir + "/server-work");
            if (workDir.exists()) {
                this.recursiveDeleteDir(workDir);
            }
            super.setup();
        }
    }

    public void tearDown() throws Exception {
        DirContext ctx = this.getDirContext();
        LDAPEmbeddedServer.clearSubContexts(ctx, new CompositeName(this.baseDn));
        if (this.isStartEmbeddedLdapLerver()) {
            super.tearDown();
        }
    }

    private DirContext getDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.connectionUrl);
        env.put("java.naming.security.principal", this.bindDn);
        env.put("java.naming.security.credentials", this.bindCredential);
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    public void setupLdapInRealm(RealmModel realm) {
        HashMap<String, String> ldapConfig = new HashMap<String, String>();
        ldapConfig.put("connectionUrl", this.getConnectionUrl());
        ldapConfig.put("baseDn", this.getBaseDn());
        ldapConfig.put("bindDn", this.getBindDn());
        ldapConfig.put("bindCredential", this.getBindCredential());
        ldapConfig.put("userDnSuffix", this.getUserDnSuffix());
        realm.setLdapServerConfig(ldapConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(DirContext ctx, Name name) throws NamingException {
        NamingEnumeration<NameClassPair> enumeration = null;
        try {
            enumeration = ctx.list(name);
            while (enumeration.hasMore()) {
                NameClassPair pair = enumeration.next();
                Name childName = ctx.composeName(new CompositeName(pair.getName()), name);
                try {
                    ctx.destroySubcontext(childName);
                }
                catch (ContextNotEmptyException e) {
                    LDAPEmbeddedServer.clearSubContexts(ctx, childName);
                    ctx.destroySubcontext(childName);
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public String getUserDnSuffix() {
        return this.userDnSuffix;
    }

    public String getRolesDnSuffix() {
        return this.rolesDnSuffix;
    }

    public String getGroupDnSuffix() {
        return this.groupDnSuffix;
    }

    public String getAgentDnSuffix() {
        return this.agentDnSuffix;
    }

    public boolean isStartEmbeddedLdapLerver() {
        return this.startEmbeddedLdapLerver;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getBindCredential() {
        return this.bindCredential;
    }

    public void importLDIF(String fileName) throws Exception {
        if (this.isStartEmbeddedLdapLerver()) {
            super.importLDIF(fileName);
        }
    }

    protected void createBaseDN() throws Exception {
        this.ds.createBaseDN("keycloak", BASE_DN);
    }
}

