/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.provider.ProviderSessionFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.util.JsonSerialization;

public class AbstractModelTest {
    protected static ProviderSessionFactory providerSessionFactory;
    protected KeycloakSession identitySession;
    protected RealmManager realmManager;
    protected ProviderSession providerSession;

    @BeforeClass
    public static void beforeClass() {
        providerSessionFactory = KeycloakApplication.createProviderSessionFactory();
        ProviderSession providerSession = providerSessionFactory.createSession();
        KeycloakSession identitySession = (KeycloakSession)providerSession.getProvider(KeycloakSession.class);
        try {
            identitySession.getTransaction().begin();
            new ApplianceBootstrap().bootstrap(identitySession, "/auth");
            identitySession.getTransaction().commit();
        }
        finally {
            providerSession.close();
        }
    }

    @AfterClass
    public static void afterClass() {
        providerSessionFactory.close();
    }

    @Before
    public void before() throws Exception {
        this.providerSession = providerSessionFactory.createSession();
        this.identitySession = (KeycloakSession)this.providerSession.getProvider(KeycloakSession.class);
        this.identitySession.getTransaction().begin();
        this.realmManager = new RealmManager(this.identitySession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() throws Exception {
        this.identitySession.getTransaction().commit();
        this.providerSession.close();
        this.providerSession = providerSessionFactory.createSession();
        this.identitySession = (KeycloakSession)this.providerSession.getProvider(KeycloakSession.class);
        try {
            this.identitySession.getTransaction().begin();
            RealmManager rm = new RealmManager(this.identitySession);
            for (RealmModel realm : this.identitySession.getRealms()) {
                if (realm.getName().equals(Config.getAdminRealm())) continue;
                rm.removeRealm(realm);
            }
            this.identitySession.getTransaction().commit();
        }
        finally {
            this.providerSession.close();
        }
    }

    protected void commit() {
        this.commit(false);
    }

    protected void commit(boolean rollback) {
        if (rollback) {
            this.identitySession.getTransaction().rollback();
        } else {
            this.identitySession.getTransaction().commit();
        }
        this.resetSession();
    }

    protected void resetSession() {
        this.providerSession.close();
        this.providerSession = providerSessionFactory.createSession();
        this.identitySession = (KeycloakSession)this.providerSession.getProvider(KeycloakSession.class);
        this.identitySession.getTransaction().begin();
        this.realmManager = new RealmManager(this.identitySession);
    }

    public static RealmRepresentation loadJson(String path) throws IOException {
        int c;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((c = is.read()) != -1) {
            os.write(c);
        }
        byte[] bytes = os.toByteArray();
        return (RealmRepresentation)JsonSerialization.readValue((byte[])bytes, RealmRepresentation.class);
    }

    public static void assertRolesEquals(Set<RoleModel> expected, Set<RoleModel> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (RoleModel current : actual) {
            AbstractModelTest.assertRolesContains(current, expected);
        }
    }

    public static void assertRolesContains(RoleModel expected, Set<RoleModel> actual) {
        for (RoleModel current : actual) {
            if (!current.getId().equals(expected.getId())) continue;
            AbstractModelTest.assertRolesEquals(current, expected);
            return;
        }
        Assert.fail((String)("Role with id=" + expected.getId() + " name=" + expected.getName() + " not in set " + actual));
    }

    public static void assertRolesEquals(RoleModel expected, RoleModel actual) {
        Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((Object)expected.getContainer(), (Object)actual.getContainer());
        Assert.assertEquals((long)expected.getComposites().size(), (long)actual.getComposites().size());
    }
}

