/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.OAuthClientManager;
import org.keycloak.services.managers.RealmManager;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AdapterTest
extends AbstractModelTest {
    private RealmModel realmModel;

    @Test
    public void test1CreateRealm() throws Exception {
        this.realmModel = this.realmManager.createRealm("JUGGLER");
        this.realmModel.setAccessCodeLifespan(100);
        this.realmModel.setAccessCodeLifespanUserAction(600);
        this.realmModel.setEnabled(true);
        this.realmModel.setName("JUGGLER");
        this.realmModel.setPrivateKeyPem("0234234");
        this.realmModel.setPublicKeyPem("0234234");
        this.realmModel.setAccessTokenLifespan(1000);
        this.realmModel.setUpdateProfileOnInitialSocialLogin(true);
        this.realmModel.addDefaultRole("foo");
        this.realmModel = this.realmManager.getRealm(this.realmModel.getId());
        Assert.assertNotNull((Object)this.realmModel);
        Assert.assertEquals((long)this.realmModel.getAccessCodeLifespan(), (long)100L);
        Assert.assertEquals((long)600L, (long)this.realmModel.getAccessCodeLifespanUserAction());
        Assert.assertEquals((long)this.realmModel.getAccessTokenLifespan(), (long)1000L);
        Assert.assertEquals((Object)this.realmModel.isEnabled(), (Object)true);
        Assert.assertEquals((Object)this.realmModel.getName(), (Object)"JUGGLER");
        Assert.assertEquals((Object)this.realmModel.getPrivateKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.getPublicKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.isUpdateProfileOnInitialSocialLogin(), (Object)true);
        Assert.assertEquals((long)1L, (long)this.realmModel.getDefaultRoles().size());
        Assert.assertEquals((Object)"foo", this.realmModel.getDefaultRoles().get(0));
    }

    @Test
    public void testRealmListing() throws Exception {
        this.realmModel = this.realmManager.createRealm("JUGGLER");
        this.realmModel.setAccessCodeLifespan(100);
        this.realmModel.setAccessCodeLifespanUserAction(600);
        this.realmModel.setEnabled(true);
        this.realmModel.setName("JUGGLER");
        this.realmModel.setPrivateKeyPem("0234234");
        this.realmModel.setPublicKeyPem("0234234");
        this.realmModel.setAccessTokenLifespan(1000);
        this.realmModel.setUpdateProfileOnInitialSocialLogin(true);
        this.realmModel.addDefaultRole("foo");
        this.realmModel = this.realmManager.getRealm(this.realmModel.getId());
        Assert.assertNotNull((Object)this.realmModel);
        Assert.assertEquals((long)this.realmModel.getAccessCodeLifespan(), (long)100L);
        Assert.assertEquals((long)600L, (long)this.realmModel.getAccessCodeLifespanUserAction());
        Assert.assertEquals((long)this.realmModel.getAccessTokenLifespan(), (long)1000L);
        Assert.assertEquals((Object)this.realmModel.isEnabled(), (Object)true);
        Assert.assertEquals((Object)this.realmModel.getName(), (Object)"JUGGLER");
        Assert.assertEquals((Object)this.realmModel.getPrivateKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.getPublicKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.isUpdateProfileOnInitialSocialLogin(), (Object)true);
        Assert.assertEquals((long)1L, (long)this.realmModel.getDefaultRoles().size());
        Assert.assertEquals((Object)"foo", this.realmModel.getDefaultRoles().get(0));
        this.realmModel.getId();
        this.commit();
        List realms = this.identitySession.getRealms();
        Assert.assertEquals((long)realms.size(), (long)2L);
    }

    @Test
    public void test2RequiredCredential() throws Exception {
        this.test1CreateRealm();
        this.realmModel.addRequiredCredential("password");
        List storedCreds = this.realmModel.getRequiredCredentials();
        Assert.assertEquals((long)1L, (long)storedCreds.size());
        HashSet<String> creds = new HashSet<String>();
        creds.add("password");
        creds.add("totp");
        this.realmModel.updateRequiredCredentials(creds);
        storedCreds = this.realmModel.getRequiredCredentials();
        Assert.assertEquals((long)2L, (long)storedCreds.size());
        boolean totp = false;
        boolean password = false;
        for (RequiredCredentialModel cred : storedCreds) {
            Assert.assertTrue((boolean)cred.isInput());
            if (cred.getType().equals("password")) {
                password = true;
                Assert.assertTrue((boolean)cred.isSecret());
                continue;
            }
            if (!cred.getType().equals("totp")) continue;
            totp = true;
            Assert.assertFalse((boolean)cred.isSecret());
        }
        Assert.assertTrue((boolean)totp);
        Assert.assertTrue((boolean)password);
    }

    @Test
    public void testCredentialValidation() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue("geheim");
        this.realmModel.updateCredential(user, cred);
        Assert.assertTrue((boolean)this.realmModel.validatePassword(user, "geheim"));
    }

    @Test
    public void testOAuthClient() throws Exception {
        this.test1CreateRealm();
        OAuthClientModel oauth = new OAuthClientManager(this.realmModel).create("oauth-client");
        oauth = this.realmModel.getOAuthClient("oauth-client");
    }

    @Test
    public void testDeleteUser() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        user.setAttribute("attr1", "val1");
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        RoleModel testRole = this.realmModel.addRole("test");
        this.realmModel.grantRole(user, testRole);
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        SocialLinkModel socialLink = new SocialLinkModel("google", "google1", user.getLoginName());
        this.realmModel.addSocialLink(user, socialLink);
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue("password");
        this.realmModel.updateCredential(user, cred);
        this.commit();
        this.realmModel = this.identitySession.getRealm("JUGGLER");
        Assert.assertTrue((boolean)this.realmModel.removeUser("bburke"));
        Assert.assertFalse((boolean)this.realmModel.removeUser("bburke"));
        Assert.assertNull((Object)this.realmModel.getUser("bburke"));
    }

    @Test
    public void testRemoveApplication() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        this.realmModel.addScopeMapping((ClientModel)client, appRole);
        RoleModel realmRole = this.realmModel.addRole("test");
        this.realmModel.addScopeMapping((ClientModel)app, realmRole);
        Assert.assertTrue((boolean)this.realmModel.removeApplication(app.getId()));
        Assert.assertFalse((boolean)this.realmModel.removeApplication(app.getId()));
        Assert.assertNull((Object)this.realmModel.getApplicationById(app.getId()));
    }

    @Test
    public void testRemoveRealm() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue("password");
        this.realmModel.updateCredential(user, cred);
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        this.realmModel.addScopeMapping((ClientModel)client, appRole);
        RoleModel realmRole = this.realmModel.addRole("test");
        RoleModel realmRole2 = this.realmModel.addRole("test2");
        realmRole.addCompositeRole(realmRole2);
        realmRole.addCompositeRole(appRole);
        this.realmModel.addScopeMapping((ClientModel)app, realmRole);
        this.commit();
        this.realmModel = this.identitySession.getRealm("JUGGLER");
        Assert.assertTrue((boolean)this.realmManager.removeRealm(this.realmModel));
        Assert.assertFalse((boolean)this.realmManager.removeRealm(this.realmModel));
        Assert.assertNull((Object)this.realmManager.getRealm(this.realmModel.getId()));
    }

    @Test
    public void testRemoveRole() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        this.realmModel.addScopeMapping((ClientModel)client, appRole);
        RoleModel realmRole = this.realmModel.addRole("test");
        this.realmModel.addScopeMapping((ClientModel)app, realmRole);
        this.commit();
        this.realmModel = this.identitySession.getRealm("JUGGLER");
        app = this.realmModel.getApplicationByName("test-app");
        Assert.assertTrue((boolean)this.realmModel.removeRoleById(realmRole.getId()));
        Assert.assertFalse((boolean)this.realmModel.removeRoleById(realmRole.getId()));
        Assert.assertNull((Object)this.realmModel.getRole(realmRole.getName()));
        Assert.assertTrue((boolean)this.realmModel.removeRoleById(appRole.getId()));
        Assert.assertFalse((boolean)this.realmModel.removeRoleById(appRole.getId()));
        Assert.assertNull((Object)app.getRole(appRole.getName()));
    }

    @Test
    public void testUserSearch() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        user.setLastName("Burke");
        user.setFirstName("Bill");
        user.setEmail("bburke@redhat.com");
        UserModel user2 = this.realmModel.addUser("doublefirst");
        user2.setFirstName("Knut Ole");
        user2.setLastName("Alver");
        user2.setEmail("knut@redhat.com");
        UserModel user3 = this.realmModel.addUser("doublelast");
        user3.setFirstName("Ole");
        user3.setLastName("Alver Veland");
        user3.setEmail("knut2@redhat.com");
        RealmManager adapter = this.realmManager;
        List userModels = adapter.searchUsers("total junk query", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)0L);
        userModels = adapter.searchUsers("Bill Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        Object bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("bill burk", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        ArrayList<String> users = new ArrayList<String>();
        for (UserModel u : adapter.searchUsers("ole alver", this.realmModel)) {
            users.add(u.getLoginName());
        }
        Object[] usernames = users.toArray(new String[users.size()]);
        Arrays.sort(usernames);
        Assert.assertArrayEquals((Object[])new String[]{"doublefirst", "doublelast"}, (Object[])usernames);
        userModels = adapter.searchUsers("bburke@redhat.com", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("rke@redhat.com", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("bburke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("BurK", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        UserModel user4 = this.realmModel.addUser("mburke");
        user4.setLastName("Burke");
        user4.setFirstName("Monica");
        user4.setEmail("mburke@redhat.com");
        user4 = this.realmModel.addUser("thor");
        user4.setLastName("Thorgersen");
        user4.setFirstName("Stian");
        user4.setEmail("thor@redhat.com");
        userModels = adapter.searchUsers("Monica Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Monica");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"mburke@redhat.com");
        userModels = adapter.searchUsers("mburke@redhat.com", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Monica");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"mburke@redhat.com");
        userModels = adapter.searchUsers("mburke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Monica");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"mburke@redhat.com");
        userModels = adapter.searchUsers("Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)2L);
        UserModel first = (UserModel)userModels.get(0);
        UserModel second = (UserModel)userModels.get(1);
        if (!first.getEmail().equals("bburke@redhat.com") && !second.getEmail().equals("bburke@redhat.com")) {
            Assert.fail();
        }
        if (!first.getEmail().equals("mburke@redhat.com") && !second.getEmail().equals("mburke@redhat.com")) {
            Assert.fail();
        }
        RealmModel otherRealm = adapter.createRealm("other");
        otherRealm.addUser("bburke");
        Assert.assertEquals((long)1L, (long)otherRealm.getUsers().size());
        Assert.assertEquals((long)1L, (long)otherRealm.searchForUser("bu").size());
    }

    @Test
    public void testRoles() throws Exception {
        this.test1CreateRealm();
        this.realmModel.addRole("admin");
        this.realmModel.addRole("user");
        Set roles = this.realmModel.getRoles();
        Assert.assertEquals((long)3L, (long)roles.size());
        UserModel user = this.realmModel.addUser("bburke");
        RoleModel realmUserRole = this.realmModel.getRole("user");
        this.realmModel.grantRole(user, realmUserRole);
        Assert.assertTrue((boolean)this.realmModel.hasRole(user, realmUserRole));
        RoleModel found = this.realmModel.getRoleById(realmUserRole.getId());
        Assert.assertNotNull((Object)found);
        AdapterTest.assertRolesEquals(found, realmUserRole);
        ApplicationModel application = this.realmModel.addApplication("app1");
        application.addRole("user");
        application.addRole("bar");
        Set appRoles = application.getRoles();
        Assert.assertEquals((long)2L, (long)appRoles.size());
        RoleModel appBarRole = application.getRole("bar");
        Assert.assertNotNull((Object)appBarRole);
        found = this.realmModel.getRoleById(appBarRole.getId());
        Assert.assertNotNull((Object)found);
        AdapterTest.assertRolesEquals(found, appBarRole);
        this.realmModel.grantRole(user, appBarRole);
        this.realmModel.grantRole(user, application.getRole("user"));
        roles = this.realmModel.getRealmRoleMappings(user);
        Assert.assertEquals((long)roles.size(), (long)2L);
        AdapterTest.assertRolesContains(realmUserRole, roles);
        Assert.assertTrue((boolean)this.realmModel.hasRole(user, realmUserRole));
        Assert.assertTrue((boolean)this.realmModel.hasRole(user, this.realmModel.getRole("foo")));
        roles = application.getApplicationRoleMappings(user);
        Assert.assertEquals((long)roles.size(), (long)2L);
        AdapterTest.assertRolesContains(application.getRole("user"), roles);
        AdapterTest.assertRolesContains(appBarRole, roles);
        Assert.assertTrue((boolean)this.realmModel.hasRole(user, appBarRole));
        Assert.assertNotEquals((Object)this.realmModel.getRole("user").getId(), (Object)application.getRole("user").getId());
        Assert.assertEquals((long)6L, (long)this.realmModel.getRoleMappings(user).size());
        this.realmModel.deleteRoleMapping(user, this.realmModel.getRole("foo"));
        this.realmModel.deleteRoleMapping(user, appBarRole);
        roles = this.realmModel.getRoleMappings(user);
        Assert.assertEquals((long)4L, (long)roles.size());
        AdapterTest.assertRolesContains(realmUserRole, roles);
        AdapterTest.assertRolesContains(application.getRole("user"), roles);
        Assert.assertFalse((boolean)this.realmModel.hasRole(user, appBarRole));
    }

    @Test
    public void testScopes() throws Exception {
        this.test1CreateRealm();
        RoleModel realmRole = this.realmModel.addRole("realm");
        ApplicationModel app1 = this.realmModel.addApplication("app1");
        RoleModel appRole = app1.addRole("app");
        ApplicationModel app2 = this.realmModel.addApplication("app2");
        this.realmModel.addScopeMapping((ClientModel)app2, realmRole);
        this.realmModel.addScopeMapping((ClientModel)app2, appRole);
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        this.realmModel.addScopeMapping((ClientModel)client, realmRole);
        this.realmModel.addScopeMapping((ClientModel)client, appRole);
        this.commit();
        this.realmModel = this.identitySession.getRealmByName("JUGGLER");
        app1 = this.realmModel.getApplicationByName("app1");
        app2 = this.realmModel.getApplicationByName("app2");
        client = this.realmModel.getOAuthClient("client");
        Set scopeMappings = this.realmModel.getScopeMappings((ClientModel)app2);
        Assert.assertEquals((long)2L, (long)scopeMappings.size());
        Assert.assertTrue((boolean)scopeMappings.contains(this.realmModel.getRole("realm")));
        Assert.assertTrue((boolean)scopeMappings.contains(app1.getRole("app")));
        scopeMappings = this.realmModel.getScopeMappings((ClientModel)client);
        Assert.assertEquals((long)2L, (long)scopeMappings.size());
        Assert.assertTrue((boolean)scopeMappings.contains(this.realmModel.getRole("realm")));
        Assert.assertTrue((boolean)scopeMappings.contains(app1.getRole("app")));
    }

    @Test
    public void testRealmNameCollisions() throws Exception {
        this.test1CreateRealm();
        this.commit();
        try {
            this.test1CreateRealm();
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.commit(true);
        this.realmManager.createRealm("JUGGLER2");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER2").setName("JUGGLER");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void testAppNameCollisions() throws Exception {
        this.realmManager.createRealm("JUGGLER1").addApplication("app1");
        this.realmManager.createRealm("JUGGLER2").addApplication("app1");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").addApplication("app1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.commit(true);
        this.realmManager.getRealmByName("JUGGLER1").addApplication("app2");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getApplicationByName("app2").setName("app1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void testClientNameCollisions() throws Exception {
        this.realmManager.createRealm("JUGGLER1").addOAuthClient("client1");
        this.realmManager.createRealm("JUGGLER2").addOAuthClient("client1");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").addOAuthClient("client1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.commit(true);
        this.realmManager.getRealmByName("JUGGLER1").addOAuthClient("client2");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getOAuthClient("client2").setClientId("client1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void testUsernameCollisions() throws Exception {
        this.realmManager.createRealm("JUGGLER1").addUser("user1");
        this.realmManager.createRealm("JUGGLER2").addUser("user1");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").addUser("user1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.commit(true);
        this.realmManager.getRealmByName("JUGGLER1").addUser("user2");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getUser("user2").setLoginName("user1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void testEmailCollisions() throws Exception {
        this.realmManager.createRealm("JUGGLER1").addUser("user1").setEmail("email@example.com");
        this.realmManager.createRealm("JUGGLER2").addUser("user1").setEmail("email@example.com");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").addUser("user2").setEmail("email@example.com");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.resetSession();
        this.realmManager.getRealmByName("JUGGLER1").addUser("user3").setEmail("email2@example.com");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getUser("user3").setEmail("email@example.com");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void testAppRoleCollisions() throws Exception {
        this.realmManager.createRealm("JUGGLER1").addRole("role1");
        this.realmManager.getRealmByName("JUGGLER1").addApplication("app1").addRole("role1");
        this.realmManager.getRealmByName("JUGGLER1").addApplication("app2").addRole("role1");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getApplicationByName("app1").addRole("role1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.commit(true);
        this.realmManager.getRealmByName("JUGGLER1").getApplicationByName("app1").addRole("role2");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getApplicationByName("app1").getRole("role2").setName("role1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void testRealmRoleCollisions() throws Exception {
        this.realmManager.createRealm("JUGGLER1").addRole("role1");
        this.realmManager.getRealmByName("JUGGLER1").addApplication("app1").addRole("role1");
        this.realmManager.getRealmByName("JUGGLER1").addApplication("app2").addRole("role1");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").addRole("role1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException e) {
            // empty catch block
        }
        this.commit(true);
        this.realmManager.getRealmByName("JUGGLER1").addRole("role2");
        this.commit();
        try {
            this.realmManager.getRealmByName("JUGGLER1").getRole("role2").setName("role1");
            this.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (ModelDuplicateException modelDuplicateException) {
            // empty catch block
        }
        this.resetSession();
    }

    @Test
    public void userSessions() throws InterruptedException {
        this.realmManager.createRealm("userSessions");
        this.realmManager.getRealmByName("userSessions").setSsoSessionIdleTimeout(5);
        UserModel user = this.realmManager.getRealmByName("userSessions").addUser("userSessions1");
        UserSessionModel userSession = this.realmManager.getRealmByName("userSessions").createUserSession(user, "127.0.0.1");
        this.commit();
        Assert.assertNotNull((Object)this.realmManager.getRealmByName("userSessions").getUserSession(userSession.getId()));
        this.commit();
        this.realmManager.getRealmByName("userSessions").removeUserSession(this.realmManager.getRealmByName("userSessions").getUserSession(userSession.getId()));
        this.commit();
        Assert.assertNull((Object)this.realmManager.getRealmByName("userSessions").getUserSession(userSession.getId()));
        userSession = this.realmManager.getRealmByName("userSessions").createUserSession(user, "127.0.0.1");
        this.commit();
        this.realmManager.getRealmByName("userSessions").removeUserSessions(user);
        this.commit();
        Assert.assertNull((Object)this.realmManager.getRealmByName("userSessions").getUserSession(userSession.getId()));
        this.realmManager.getRealmByName("userSessions").setSsoSessionIdleTimeout(1);
        userSession = this.realmManager.getRealmByName("userSessions").createUserSession(user, "127.0.0.1");
        this.commit();
        Thread.sleep(2000L);
        this.realmManager.getRealmByName("userSessions").removeExpiredUserSessions();
        this.commit();
        Assert.assertNull((Object)this.realmManager.getRealmByName("userSessions").getUserSession(userSession.getId()));
    }

    @Test
    public void userSessionAssociations() {
        RealmModel realm = this.realmManager.createRealm("userSessions");
        UserModel user = realm.addUser("userSessions1");
        UserSessionModel userSession = realm.createUserSession(user, "127.0.0.1");
        ApplicationModel app1 = realm.addApplication("app1");
        ApplicationModel app2 = realm.addApplication("app2");
        OAuthClientModel client1 = realm.addOAuthClient("client1");
        Assert.assertEquals((long)0L, (long)userSession.getClientAssociations().size());
        userSession.associateClient((ClientModel)app1);
        userSession.associateClient((ClientModel)client1);
        Assert.assertEquals((long)2L, (long)userSession.getClientAssociations().size());
        Assert.assertTrue((boolean)app1.getUserSessions().contains(userSession));
        Assert.assertFalse((boolean)app2.getUserSessions().contains(userSession));
        Assert.assertTrue((boolean)client1.getUserSessions().contains(userSession));
        this.commit();
        realm = this.realmManager.getRealm("userSessions");
        userSession = realm.getUserSession(userSession.getId());
        app1 = realm.getApplicationByName("app1");
        client1 = realm.getOAuthClient("client1");
        userSession.removeAssociatedClient((ClientModel)app1);
        Assert.assertEquals((long)1L, (long)userSession.getClientAssociations().size());
        Assert.assertEquals((Object)client1, userSession.getClientAssociations().get(0));
        Assert.assertFalse((boolean)app1.getUserSessions().contains(userSession));
        this.commit();
        realm = this.realmManager.getRealm("userSessions");
        userSession = realm.getUserSession(userSession.getId());
        client1 = realm.getOAuthClient("client1");
        userSession.removeAssociatedClient((ClientModel)client1);
        Assert.assertEquals((long)0L, (long)userSession.getClientAssociations().size());
        Assert.assertFalse((boolean)client1.getUserSessions().contains(userSession));
    }
}

