/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.RealmModel;

public class AuthProvidersConfigTest
extends AbstractModelTest {
    @Test
    public void testConfiguration() {
        RealmModel realm = this.realmManager.createRealm("test");
        HashMap<String, String> ldapConfig = new HashMap<String, String>();
        ldapConfig.put("connectionUrl", "ldap://localhost:10389");
        ldapConfig.put("baseDn", "dc=keycloak,dc=org");
        realm.setLdapServerConfig(ldapConfig);
        AuthenticationProviderModel ap1 = new AuthenticationProviderModel("model", true, Collections.EMPTY_MAP);
        AuthenticationProviderModel ap2 = new AuthenticationProviderModel("externalModel", true, Collections.EMPTY_MAP);
        AuthenticationProviderModel ap3 = new AuthenticationProviderModel("picketlink", true, Collections.EMPTY_MAP);
        ArrayList<AuthenticationProviderModel> authProviders = new ArrayList<AuthenticationProviderModel>();
        authProviders.add(ap1);
        authProviders.add(ap2);
        authProviders.add(ap3);
        realm.setAuthenticationProviders(authProviders);
        this.commit();
        RealmModel persisted = this.realmManager.getRealm(realm.getId());
        Assert.assertEquals((Object)persisted.getLdapServerConfig(), ldapConfig);
        List persProviders = persisted.getAuthenticationProviders();
        Assert.assertEquals((long)persProviders.size(), (long)3L);
        this.assertProviderEquals((AuthenticationProviderModel)persProviders.get(0), ap1);
        this.assertProviderEquals((AuthenticationProviderModel)persProviders.get(1), ap2);
        this.assertProviderEquals((AuthenticationProviderModel)persProviders.get(2), ap3);
        authProviders = new ArrayList();
        authProviders.add(ap3);
        authProviders.add(ap2);
        authProviders.add(ap1);
        persisted.setAuthenticationProviders(authProviders);
        this.commit();
        persisted = this.realmManager.getRealm(realm.getId());
        persProviders = persisted.getAuthenticationProviders();
        Assert.assertEquals((long)persProviders.size(), (long)3L);
        this.assertProviderEquals((AuthenticationProviderModel)persProviders.get(0), ap3);
        this.assertProviderEquals((AuthenticationProviderModel)persProviders.get(1), ap2);
        this.assertProviderEquals((AuthenticationProviderModel)persProviders.get(2), ap1);
    }

    private void assertProviderEquals(AuthenticationProviderModel prov1, AuthenticationProviderModel prov2) {
        Assert.assertEquals((Object)prov1.getProviderName(), (Object)prov2.getProviderName());
        Assert.assertEquals((Object)prov1.isPasswordUpdateSupported(), (Object)prov2.isPasswordUpdateSupported());
        Assert.assertEquals((Object)prov1.getConfig(), (Object)prov2.getConfig());
    }
}

