/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.authentication.AuthenticationProviderManager;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.managers.AuthenticationManager;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AuthProvidersExternalModelTest
extends AbstractModelTest {
    private RealmModel realm1;
    private RealmModel realm2;
    private AuthenticationManager am;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.realm1 = this.realmManager.createRealm("realm1");
        this.realm1.setBruteForceProtected(false);
        this.realm2 = this.realmManager.createRealm("realm2");
        this.realm2.setBruteForceProtected(false);
        this.realm1.addRequiredCredential("password");
        this.realm2.addRequiredCredential("password");
        this.realm1.setAuthenticationProviders(Arrays.asList(AuthenticationProviderModel.DEFAULT_PROVIDER));
        this.realm2.setAuthenticationProviders(Arrays.asList(AuthenticationProviderModel.DEFAULT_PROVIDER));
        UserModel john = this.realm1.addUser("john");
        john.setEnabled(true);
        john.setFirstName("John");
        john.setLastName("Doe");
        john.setEmail("john@email.org");
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType("password");
        credential.setValue("password");
        this.realm1.updateCredential(john, credential);
        this.am = new AuthenticationManager(this.providerSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalModelAuthentication() {
        MultivaluedMap<String, String> formData = AuthProvidersExternalModelTest.createFormData("john", "password");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm1, formData));
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_USER, (Object)this.am.authenticateForm(null, this.realm2, formData));
        Assert.assertNull((Object)this.realm2.getUser("john"));
        this.setupAuthenticationProviders();
        try {
            ResteasyProviderFactory.pushContext(KeycloakSession.class, (Object)this.identitySession);
            Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm2, formData));
            UserModel john2 = this.realm2.getUser("john");
            Assert.assertNotNull((Object)john2);
            Assert.assertEquals((Object)"john", (Object)john2.getLoginName());
            Assert.assertEquals((Object)"John", (Object)john2.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)john2.getLastName());
            Assert.assertEquals((Object)"john@email.org", (Object)john2.getEmail());
            AuthenticationLinkModel authLink = this.realm2.getAuthenticationLink(john2);
            Assert.assertNotNull((Object)authLink);
            Assert.assertEquals((Object)authLink.getAuthProvider(), (Object)"externalModel");
            Assert.assertEquals((Object)authLink.getAuthUserId(), (Object)this.realm1.getUser("john").getId());
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalModelPasswordUpdate() {
        this.setupAuthenticationProviders();
        UserModel john = this.realm2.addUser("john");
        john.setEnabled(true);
        this.realm2.setAuthenticationLink(john, new AuthenticationLinkModel("externalModel", this.realm1.getUser("john").getId()));
        try {
            ResteasyProviderFactory.pushContext(KeycloakSession.class, (Object)this.identitySession);
            AuthenticationProviderManager authProviderManager = AuthenticationProviderManager.getManager((RealmModel)this.realm2, (ProviderSession)this.providerSession);
            try {
                Assert.assertTrue((boolean)authProviderManager.updatePassword(john, "password-updated"));
            }
            catch (AuthenticationProviderException ape) {
                ape.printStackTrace();
                Assert.fail((String)"Error not expected");
            }
            MultivaluedMap<String, String> formData = AuthProvidersExternalModelTest.createFormData("john", "password-updated");
            Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm1, formData));
            Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm2, formData));
            AuthProvidersExternalModelTest.setPasswordUpdateForProvider(false, "externalModel", this.realm2);
            try {
                Assert.assertFalse((boolean)authProviderManager.updatePassword(john, "password-updated2"));
            }
            catch (AuthenticationProviderException ape) {
                ape.printStackTrace();
                Assert.fail((String)"Error not expected");
            }
            formData = AuthProvidersExternalModelTest.createFormData("john", "password-updated2");
            Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)this.am.authenticateForm(null, this.realm1, formData));
            Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)this.am.authenticateForm(null, this.realm2, formData));
            AuthProvidersExternalModelTest.setPasswordUpdateForProvider(true, "externalModel", this.realm2);
            this.realm1.setPasswordPolicy(new PasswordPolicy("length(8)"));
            try {
                authProviderManager.updatePassword(john, "passw");
                Assert.fail((String)"Update not expected to pass");
            }
            catch (AuthenticationProviderException ape) {
                // empty catch block
            }
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    private void setupAuthenticationProviders() {
        AuthenticationProviderModel ap1 = new AuthenticationProviderModel("model", true, Collections.EMPTY_MAP);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("externalRealmId", "realm1");
        AuthenticationProviderModel ap2 = new AuthenticationProviderModel("externalModel", true, config);
        this.realm2.setAuthenticationProviders(Arrays.asList(ap1, ap2));
    }

    public static void setPasswordUpdateForProvider(boolean isPasswordUpdate, String providerName, RealmModel realm) {
        List authProviders = realm.getAuthenticationProviders();
        for (AuthenticationProviderModel authProvider : authProviders) {
            if (!providerName.equals(authProvider.getProviderName())) continue;
            authProvider.setPasswordUpdateSupported(isPasswordUpdate);
            break;
        }
        realm.setAuthenticationProviders(authProviders);
    }

    public static MultivaluedMap<String, String> createFormData(String username, String password) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"username", (Object)username);
        formData.add((Object)"password", (Object)password);
        return formData;
    }
}

