/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.core.MultivaluedMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.authentication.AuthenticationProviderManager;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.model.test.AuthProvidersExternalModelTest;
import org.keycloak.model.test.LDAPEmbeddedServer;
import org.keycloak.model.test.LdapTestUtils;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.managers.AuthenticationManager;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AuthProvidersLDAPTest
extends AbstractModelTest {
    private static LDAPEmbeddedServer embeddedServer;
    private RealmModel realm;
    private AuthenticationManager am;

    @BeforeClass
    public static void beforeClass() {
        AbstractModelTest.beforeClass();
        try {
            embeddedServer = new LDAPEmbeddedServer();
            embeddedServer.setup();
            embeddedServer.importLDIF("ldap/users.ldif");
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting Embedded LDAP server.", e);
        }
    }

    @AfterClass
    public static void afterClass() {
        AbstractModelTest.afterClass();
        try {
            embeddedServer.tearDown();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting Embedded LDAP server.", e);
        }
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.realm = this.realmManager.createRealm("realm");
        this.realm.setBruteForceProtected(false);
        this.realm.addRequiredCredential("password");
        embeddedServer.setupLdapInRealm(this.realm);
        this.am = new AuthenticationManager(this.providerSession);
    }

    @Test
    public void testLdapAuthentication() {
        MultivaluedMap<String, String> formData = AuthProvidersExternalModelTest.createFormData("john", "password");
        LdapTestUtils.setLdapPassword((ProviderSession)this.providerSession, (RealmModel)this.realm, (String)"john", (String)"password");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_USER, (Object)this.am.authenticateForm(null, this.realm, formData));
        Assert.assertNull((Object)this.realm.getUser("john"));
        this.setupAuthenticationProviders();
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm, formData));
        UserModel john = this.realm.getUser("john");
        Assert.assertNotNull((Object)john);
        Assert.assertEquals((Object)"john", (Object)john.getLoginName());
        Assert.assertEquals((Object)"John", (Object)john.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)john.getLastName());
        Assert.assertEquals((Object)"john@email.org", (Object)john.getEmail());
        AuthenticationLinkModel authLink = this.realm.getAuthenticationLink(john);
        Assert.assertNotNull((Object)authLink);
        Assert.assertEquals((Object)authLink.getAuthProvider(), (Object)"picketlink");
    }

    @Test
    public void testLdapInvalidAuthentication() {
        this.setupAuthenticationProviders();
        UserModel realmUser = this.realm.addUser("realmUser");
        realmUser.setEnabled(true);
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType("password");
        credential.setValue("pass");
        this.realm.updateCredential(realmUser, credential);
        MultivaluedMap<String, String> formData = AuthProvidersExternalModelTest.createFormData("invalid", "invalid");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_USER, (Object)this.am.authenticateForm(null, this.realm, formData));
        formData = AuthProvidersExternalModelTest.createFormData("john", "invalid");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)this.am.authenticateForm(null, this.realm, formData));
        formData = AuthProvidersExternalModelTest.createFormData("realmUser", "invalid");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)this.am.authenticateForm(null, this.realm, formData));
        realmUser.setEnabled(false);
        formData = AuthProvidersExternalModelTest.createFormData("realmUser", "pass");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.ACCOUNT_DISABLED, (Object)this.am.authenticateForm(null, this.realm, formData));
        realmUser.setEnabled(true);
        formData = AuthProvidersExternalModelTest.createFormData("realmUser", "pass");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm, formData));
    }

    @Test
    public void testLdapPasswordUpdate() {
        this.setupAuthenticationProviders();
        LdapTestUtils.setLdapPassword((ProviderSession)this.providerSession, (RealmModel)this.realm, (String)"john", (String)"password");
        MultivaluedMap<String, String> formData = AuthProvidersExternalModelTest.createFormData("john", "password");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm, formData));
        AuthenticationProviderManager authProviderManager = AuthenticationProviderManager.getManager((RealmModel)this.realm, (ProviderSession)this.providerSession);
        UserModel john = this.realm.getUser("john");
        try {
            Assert.assertTrue((boolean)authProviderManager.updatePassword(john, "password-updated"));
        }
        catch (AuthenticationProviderException ape) {
            ape.printStackTrace();
            Assert.fail((String)"Error not expected");
        }
        formData = AuthProvidersExternalModelTest.createFormData("john", "password-updated");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)this.am.authenticateForm(null, this.realm, formData));
        Assert.assertFalse((boolean)this.realm.validatePassword(john, "password-updated"));
        AuthProvidersExternalModelTest.setPasswordUpdateForProvider(false, "picketlink", this.realm);
        try {
            Assert.assertFalse((boolean)authProviderManager.updatePassword(john, "password-updated2"));
        }
        catch (AuthenticationProviderException ape) {
            ape.printStackTrace();
            Assert.fail((String)"Error not expected");
        }
        formData = AuthProvidersExternalModelTest.createFormData("john", "password-updated2");
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)this.am.authenticateForm(null, this.realm, formData));
    }

    private void setupAuthenticationProviders() {
        AuthenticationProviderModel ap1 = new AuthenticationProviderModel("model", false, Collections.EMPTY_MAP);
        AuthenticationProviderModel ap2 = new AuthenticationProviderModel("picketlink", true, Collections.EMPTY_MAP);
        this.realm.setAuthenticationProviders(Arrays.asList(ap1, ap2));
    }
}

