/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.Arrays;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.services.ClientConnection;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;

public class AuthenticationManagerTest
extends AbstractModelTest {
    private AuthenticationManager am;
    private MultivaluedMap<String, String> formData;
    private TimeBasedOTP otp;
    private RealmModel realm;
    private UserModel user;
    private BruteForceProtector protector;
    private ClientConnection dummyConnection = new ClientConnection(){

        public String getRemoteAddr() {
            return "127.0.0.1";
        }

        public String getRemoteHost() {
            return "localhost";
        }

        public int getReportPort() {
            return 8080;
        }
    };

    @Test
    public void authForm() {
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)status);
    }

    @Test
    public void authFormInvalidPassword() {
        this.formData.remove((Object)"password");
        this.formData.add((Object)"password", (Object)"invalid");
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)status);
    }

    @Test
    public void authFormMissingUsername() {
        this.formData.remove((Object)"username");
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_USER, (Object)status);
    }

    @Test
    public void authFormMissingPassword() {
        this.formData.remove((Object)"password");
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.MISSING_PASSWORD, (Object)status);
    }

    @Test
    public void authFormRequiredAction() {
        this.realm.addRequiredCredential("totp");
        this.user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.ACTIONS_REQUIRED, (Object)status);
    }

    @Test
    public void authFormUserDisabled() {
        this.user.setEnabled(false);
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.ACCOUNT_DISABLED, (Object)status);
    }

    @Test
    public void authFormWithTotp() {
        this.realm.addRequiredCredential("totp");
        String totpSecret = UUID.randomUUID().toString();
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType("totp");
        credential.setValue(totpSecret);
        this.realm.updateCredential(this.user, credential);
        this.user.setTotp(true);
        String token = this.otp.generate(totpSecret);
        this.formData.add((Object)"totp", (Object)token);
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.SUCCESS, (Object)status);
    }

    @Test
    public void authFormWithTotpInvalidPassword() {
        this.authFormWithTotp();
        this.formData.remove((Object)"password");
        this.formData.add((Object)"password", (Object)"invalid");
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)status);
    }

    @Test
    public void authFormWithTotpInvalidTotp() {
        this.authFormWithTotp();
        this.formData.remove((Object)"totp");
        this.formData.add((Object)"totp", (Object)"invalid");
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.INVALID_CREDENTIALS, (Object)status);
    }

    @Test
    public void authFormWithTotpMissingTotp() {
        this.authFormWithTotp();
        this.formData.remove((Object)"totp");
        AuthenticationManager.AuthenticationStatus status = this.am.authenticateForm(this.dummyConnection, this.realm, this.formData);
        Assert.assertEquals((Object)AuthenticationManager.AuthenticationStatus.MISSING_TOTP, (Object)status);
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.realm = this.realmManager.createRealm("Test");
        this.realm.setAccessCodeLifespan(100);
        this.realm.setEnabled(true);
        this.realm.setName("Test");
        this.realm.setPrivateKeyPem("0234234");
        this.realm.setPublicKeyPem("0234234");
        this.realm.setAccessTokenLifespan(1000);
        this.realm.addRequiredCredential("password");
        this.realm.setAuthenticationProviders(Arrays.asList(AuthenticationProviderModel.DEFAULT_PROVIDER));
        this.protector = new BruteForceProtector(providerSessionFactory);
        this.protector.start();
        this.am = new AuthenticationManager(this.providerSession, this.protector);
        this.user = this.realm.addUser("test");
        this.user.setEnabled(true);
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType("password");
        credential.setValue("password");
        this.realm.updateCredential(this.user, credential);
        this.formData = new MultivaluedMapImpl();
        this.formData.add((Object)"username", (Object)"test");
        this.formData.add((Object)"password", (Object)"password");
        this.otp = new TimeBasedOTP();
    }

    @Override
    @After
    public void after() throws Exception {
        this.protector.shutdown();
        super.after();
    }
}

