import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import styles from "../../@patternfly/patternfly/components/Form/form.css.js";
import { ASTERISK } from '../../helpers/htmlConstants';
import { FormContext } from './FormContext';
import { css, getModifier } from '@patternfly/react-styles';
export var FormGroup = function FormGroup(_ref) {
  var _ref$children = _ref.children,
      children = _ref$children === void 0 ? null : _ref$children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      label = _ref.label,
      _ref$isRequired = _ref.isRequired,
      isRequired = _ref$isRequired === void 0 ? false : _ref$isRequired,
      _ref$isValid = _ref.isValid,
      isValid = _ref$isValid === void 0 ? true : _ref$isValid,
      _ref$isInline = _ref.isInline,
      isInline = _ref$isInline === void 0 ? false : _ref$isInline,
      helperText = _ref.helperText,
      helperTextInvalid = _ref.helperTextInvalid,
      fieldId = _ref.fieldId,
      props = _objectWithoutProperties(_ref, ["children", "className", "label", "isRequired", "isValid", "isInline", "helperText", "helperTextInvalid", "fieldId"]);

  return React.createElement(FormContext.Consumer, null, function (_ref2) {
    var isHorizontal = _ref2.isHorizontal;
    return React.createElement("div", _extends({}, props, {
      className: css(styles.formGroup, isInline ? getModifier(styles, 'inline', className) : '')
    }), label && React.createElement("label", {
      className: css(styles.formLabel),
      htmlFor: fieldId
    }, label, isRequired && React.createElement("span", {
      className: css(styles.formLabelRequired),
      "aria-hidden": "true"
    }, ASTERISK)), isHorizontal ? React.createElement("div", {
      className: css(styles.formHorizontalGroup)
    }, children) : children, (isValid && helperText || !isValid && helperTextInvalid) && React.createElement("div", {
      className: css(styles.formHelperText, !isValid ? getModifier(styles, 'error') : ''),
      id: "".concat(fieldId, "-helper"),
      "aria-live": "polite"
    }, isValid ? helperText : helperTextInvalid));
  });
};
FormGroup.propTypes = {
  children: _pt.node,
  className: _pt.string,
  label: _pt.node,
  isRequired: _pt.bool,
  isValid: _pt.bool,
  isInline: _pt.bool,
  helperText: _pt.node,
  helperTextInvalid: _pt.node,
  fieldId: _pt.string.isRequired
};