import * as React from 'react';
export declare enum ButtonVariant {
    primary = "primary",
    secondary = "secondary",
    tertiary = "tertiary",
    danger = "danger",
    link = "link",
    plain = "plain"
}
export declare enum ButtonType {
    button = "button",
    submit = "submit"
}
export interface ButtonProps extends React.HTMLProps<HTMLButtonElement> {
    /** Content rendered inside the button */
    children?: React.ReactNode;
    /** Additional classes added to the button */
    className?: string;
    /** Sets the base component to render. defaults to button */
    component?: React.ReactNode;
    /** Adds active styling to button. */
    isActive?: boolean;
    /** Adds block styling to button */
    isBlock?: boolean;
    /** Disables the button and adds disabled styling */
    isDisabled?: boolean;
    /** Adds focus styling to the button */
    isFocus?: boolean;
    /** Adds hover styling to the button */
    isHover?: boolean;
    /** Adds inline styling to a link button */
    isInline?: boolean;
    /** Sets button type */
    type?: 'button' | 'submit';
    /** Adds button variant styles */
    variant?: 'primary' | 'secondary' | 'tertiary' | 'danger' | 'link' | 'plain';
    /** Adds accessible text to the button. */
    'aria-label'?: string;
}
export declare const Button: React.FunctionComponent<ButtonProps>;
