"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "../../@patternfly/patternfly/components/Nav/nav.css.js", "@patternfly/react-styles", "./Nav"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("../../@patternfly/patternfly/components/Nav/nav.css.js"), require("@patternfly/react-styles"), require("./Nav"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.navCss, global.reactStyles, global.Nav);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _navCss, _reactStyles, _Nav) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.NavItem = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _navCss2 = _interopRequireDefault(_navCss);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var NavItem = exports.NavItem = function NavItem(_ref) {
    var _ref$children = _ref.children,
        children = _ref$children === void 0 ? null : _ref$children,
        _ref$className = _ref.className,
        className = _ref$className === void 0 ? '' : _ref$className,
        _ref$to = _ref.to,
        to = _ref$to === void 0 ? '' : _ref$to,
        _ref$isActive = _ref.isActive,
        isActive = _ref$isActive === void 0 ? false : _ref$isActive,
        _ref$groupId = _ref.groupId,
        groupId = _ref$groupId === void 0 ? null : _ref$groupId,
        _ref$itemId = _ref.itemId,
        itemId = _ref$itemId === void 0 ? null : _ref$itemId,
        _ref$preventDefault = _ref.preventDefault,
        preventDefault = _ref$preventDefault === void 0 ? false : _ref$preventDefault,
        _ref$onClick = _ref.onClick,
        _onClick = _ref$onClick === void 0 ? null : _ref$onClick,
        props = _objectWithoutProperties(_ref, ["children", "className", "to", "isActive", "groupId", "itemId", "preventDefault", "onClick"]);

    var renderDefaultLink = function renderDefaultLink() {
      var preventLinkDefault = preventDefault || !to;
      return React.createElement(_Nav.NavContext.Consumer, null, function (context) {
        return React.createElement("a", _extends({
          href: to,
          onClick: function onClick(e) {
            return context.onSelect(e, groupId, itemId, to, preventLinkDefault, _onClick);
          },
          className: (0, _reactStyles.css)(_navCss2["default"].navLink, isActive && _navCss2["default"].modifiers.current, className),
          "aria-current": isActive ? 'page' : null
        }, props), children);
      });
    };

    var renderClonedChild = function renderClonedChild(child) {
      return React.createElement(_Nav.NavContext.Consumer, null, function (context) {
        return React.cloneElement(child, {
          onClick: function onClick(e) {
            return context.onSelect(e, groupId, itemId, to, preventDefault, _onClick);
          },
          className: (0, _reactStyles.css)(_navCss2["default"].navLink, isActive && _navCss2["default"].modifiers.current, className),
          'aria-current': isActive ? 'page' : null
        });
      });
    };

    return React.createElement("li", {
      className: (0, _reactStyles.css)(_navCss2["default"].navItem, className)
    }, React.isValidElement(children) ? renderClonedChild(children) : renderDefaultLink());
  };

  NavItem.propTypes = {
    children: _propTypes2["default"].node,
    className: _propTypes2["default"].string,
    to: _propTypes2["default"].string,
    isActive: _propTypes2["default"].bool,
    groupId: _propTypes2["default"].oneOfType([_propTypes2["default"].string, _propTypes2["default"].number, _propTypes2["default"].oneOf([null])]),
    itemId: _propTypes2["default"].oneOfType([_propTypes2["default"].string, _propTypes2["default"].number, _propTypes2["default"].oneOf([null])]),
    preventDefault: _propTypes2["default"].bool,
    onClick: _propTypes2["default"].func
  };
});