"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const util = __importStar(require("../util"));
exports.default = util.createRule({
    name: 'interface-name-prefix',
    meta: {
        type: 'suggestion',
        docs: {
            description: 'Require that interface names be prefixed with `I`',
            tslintRuleName: 'interface-name',
            category: 'Stylistic Issues',
            recommended: 'error',
        },
        messages: {
            noPrefix: 'Interface name must not be prefixed with "I".',
        },
        schema: [
            {
                enum: ['never', 'always'],
            },
        ],
    },
    defaultOptions: ['never'],
    create(context, [option]) {
        const never = option !== 'always';
        /**
         * Checks if a string is prefixed with "I".
         * @param name The string to check
         */
        function isPrefixedWithI(name) {
            if (typeof name !== 'string') {
                return false;
            }
            return /^I[A-Z]/.test(name);
        }
        return {
            TSInterfaceDeclaration(node) {
                if (never) {
                    if (isPrefixedWithI(node.id.name)) {
                        context.report({
                            node: node.id,
                            messageId: 'noPrefix',
                        });
                    }
                }
                else {
                    if (!isPrefixedWithI(node.id.name)) {
                        context.report({
                            node: node.id,
                            messageId: 'noPrefix',
                        });
                    }
                }
            },
        };
    },
});
//# sourceMappingURL=interface-name-prefix.js.map