/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.integration.elytron;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.adapters.authorization.integration.elytron.ElytronPolicyEnforcerFilter;
import org.keycloak.adapters.authorization.spi.ConfigurationResolver;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.util.JsonSerialization;

@WebListener
public class PolicyEnforcerServletContextListener
implements ServletContextListener {
    private final Logger logger = Logger.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent sce) {
        ConfigurationResolver configResolver;
        ServletContext servletContext = sce.getServletContext();
        Iterator<ConfigurationResolver> configResolvers = ServiceLoader.load(ConfigurationResolver.class).iterator();
        if (configResolvers.hasNext()) {
            configResolver = configResolvers.next();
            if (configResolvers.hasNext()) {
                throw new IllegalStateException("Multiple " + ConfigurationResolver.class.getName() + " implementations found");
            }
            this.logger.debugf("Configuration resolver found from classpath: %s", (Object)configResolver);
        } else {
            String enforcerConfigLocation = "WEB-INF/policy-enforcer.json";
            InputStream config = servletContext.getResourceAsStream(enforcerConfigLocation);
            if (config == null) {
                this.logger.debugf("Could not find the policy enforcer configuration file: %s", (Object)enforcerConfigLocation);
                return;
            }
            try {
                configResolver = this.createDefaultConfigurationResolver((PolicyEnforcerConfig)JsonSerialization.readValue((InputStream)config, PolicyEnforcerConfig.class));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse policy enforcer configuration: " + enforcerConfigLocation);
            }
        }
        this.logger.debug((Object)"Policy enforcement filter is enabled.");
        servletContext.addFilter("keycloak-policy-enforcer", (Filter)new ElytronPolicyEnforcerFilter(configResolver)).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
    }

    private ConfigurationResolver createDefaultConfigurationResolver(final PolicyEnforcerConfig enforcerConfig) {
        return new ConfigurationResolver(){

            @Override
            public PolicyEnforcerConfig resolve(HttpRequest request) {
                return enforcerConfig;
            }
        };
    }
}

