/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.adapters.saml.config.Key;
import org.keycloak.adapters.saml.config.parsers.KeyXmlParser;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.util.StaxParserUtil;

public class KeysXmlParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"Keys");
        LinkedList<Key> keys = new LinkedList<Key>();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementName.equals("Keys")) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("Key")) {
                KeyXmlParser parser = new KeyXmlParser();
                Key key = (Key)parser.parse(xmlEventReader);
                keys.add(key);
                continue;
            }
            StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)tag);
        }
        return keys;
    }

    public boolean supports(QName qname) {
        return false;
    }
}

