/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.SecurityActions;
import org.keycloak.saml.common.util.SystemPropertiesUtil;
import org.keycloak.saml.common.util.TransformerUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static DocumentBuilderFactory documentBuilderFactory;
    public static final String feature_external_general_entities = "http://xml.org/sax/features/external-general-entities";
    public static final String feature_external_parameter_entities = "http://xml.org/sax/features/external-parameter-entities";
    public static final String feature_disallow_doctype_decl = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final ThreadLocal<DocumentBuilder> XML_DOCUMENT_BUILDER;

    public static Document createDocument() throws ConfigurationException {
        DocumentBuilder builder;
        try {
            builder = DocumentUtil.getDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return builder.newDocument();
    }

    public static Document createDocumentWithBaseNamespace(String baseNamespace, String localPart) throws ProcessingException {
        try {
            DocumentBuilder builder = DocumentUtil.getDocumentBuilder();
            return builder.getDOMImplementation().createDocument(baseNamespace, localPart, null);
        }
        catch (DOMException e) {
            throw logger.processingError(e);
        }
        catch (ParserConfigurationException e) {
            throw logger.processingError(e);
        }
    }

    public static Document getDocument(String docString) throws ConfigurationException, ParsingException, ProcessingException {
        return DocumentUtil.getDocument(new StringReader(docString));
    }

    public static Document getDocument(Reader reader) throws ConfigurationException, ProcessingException, ParsingException {
        try {
            DocumentBuilder builder = DocumentUtil.getDocumentBuilder();
            return builder.parse(new InputSource(reader));
        }
        catch (ParserConfigurationException e) {
            throw logger.configurationError(e);
        }
        catch (SAXException e) {
            throw logger.parserError(e);
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
    }

    public static Document getDocument(File file) throws ConfigurationException, ProcessingException, ParsingException {
        try {
            DocumentBuilder builder = DocumentUtil.getDocumentBuilder();
            return builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw logger.configurationError(e);
        }
        catch (SAXException e) {
            throw logger.parserError(e);
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
    }

    public static Document getDocument(InputStream is) throws ConfigurationException, ProcessingException, ParsingException {
        try {
            DocumentBuilder builder = DocumentUtil.getDocumentBuilder();
            return builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw logger.configurationError(e);
        }
        catch (SAXException e) {
            throw logger.parserError(e);
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
    }

    public static String getDocumentAsString(Document signedDoc) throws ProcessingException, ConfigurationException {
        return DocumentUtil.getNodeAsString(signedDoc);
    }

    public static String getNodeAsString(Node node) throws ProcessingException, ConfigurationException {
        DOMSource source = new DOMSource(node);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = TransformerUtil.getTransformer();
        try {
            xformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw logger.processingError(e);
        }
        return sw.toString();
    }

    public static Element getElement(Document doc, QName elementQName) {
        NodeList nl = doc.getElementsByTagNameNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        if (nl.getLength() == 0) {
            nl = doc.getElementsByTagNameNS("*", elementQName.getLocalPart());
            if (nl.getLength() == 0) {
                nl = doc.getElementsByTagName(elementQName.getPrefix() + ":" + elementQName.getLocalPart());
            }
            if (nl.getLength() == 0) {
                return null;
            }
        }
        return (Element)nl.item(0);
    }

    public static Element getChildElement(Element doc, QName elementQName) {
        NodeList nl = doc.getElementsByTagNameNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        if (nl.getLength() == 0) {
            nl = doc.getElementsByTagNameNS("*", elementQName.getLocalPart());
            if (nl.getLength() == 0) {
                nl = doc.getElementsByTagName(elementQName.getPrefix() + ":" + elementQName.getLocalPart());
            }
            if (nl.getLength() == 0) {
                return null;
            }
        }
        return (Element)nl.item(0);
    }

    public static InputStream getNodeAsStream(Node node) throws ConfigurationException, ProcessingException {
        return DocumentUtil.getSourceAsStream(new DOMSource(node));
    }

    public static InputStream getSourceAsStream(Source source) throws ConfigurationException, ProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = TransformerUtil.getTransformer();
        try {
            transformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw logger.processingError(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static Source getXMLSource(Document doc) {
        return new DOMSource(doc);
    }

    public static String asString(Document doc) {
        String str = null;
        try {
            str = DocumentUtil.getDocumentAsString(doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private static void visit(Node node, int level) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            logger.trace("Node=" + childNode.getNamespaceURI() + "::" + childNode.getLocalName());
            DocumentUtil.visit(childNode, level + 1);
        }
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder res = XML_DOCUMENT_BUILDER.get();
        res.reset();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        if (documentBuilderFactory == null) {
            try {
                if (tccl_jaxp) {
                    SecurityActions.setTCCL(DocumentUtil.class.getClassLoader());
                }
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setXIncludeAware(false);
                String feature = "";
                try {
                    feature = feature_disallow_doctype_decl;
                    documentBuilderFactory.setFeature(feature, true);
                    feature = feature_external_general_entities;
                    documentBuilderFactory.setFeature(feature, false);
                    feature = feature_external_parameter_entities;
                    documentBuilderFactory.setFeature(feature, false);
                }
                catch (ParserConfigurationException e) {
                    throw logger.parserFeatureNotSupported(feature);
                }
            }
            finally {
                if (tccl_jaxp) {
                    SecurityActions.setTCCL(prevTCCL);
                }
            }
        }
        return documentBuilderFactory;
    }

    public static Element getDirectChildElement(Element parent, String targetNamespace, String targetLocalName) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            String ns = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (!Objects.equals(targetNamespace, ns) || !Objects.equals(targetLocalName, localName)) continue;
            return childElement;
        }
        return null;
    }

    static {
        XML_DOCUMENT_BUILDER = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                DocumentBuilderFactory factory = DocumentUtil.getDocumentBuilderFactory();
                try {
                    return factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }
}

