/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SignatureAlgorithm;

public interface SamlDeployment {
    public IDP getIDP();

    public boolean isConfigured();

    public SslRequired getSslRequired();

    public String getEntityID();

    public String getNameIDPolicyFormat();

    public boolean isForceAuthentication();

    public boolean isIsPassive();

    public boolean turnOffChangeSessionIdOnLogin();

    public PrivateKey getDecryptionKey();

    public KeyPair getSigningKeyPair();

    public String getSignatureCanonicalizationMethod();

    public SignatureAlgorithm getSignatureAlgorithm();

    public String getLogoutPage();

    public Set<String> getRoleAttributeNames();

    public PrincipalNamePolicy getPrincipalNamePolicy();

    public String getPrincipalAttributeName();

    public boolean isAutodetectBearerOnly();

    public static enum PrincipalNamePolicy {
        FROM_NAME_ID,
        FROM_ATTRIBUTE;

    }

    public static interface IDP {
        public String getEntityID();

        public SingleSignOnService getSingleSignOnService();

        public SingleLogoutService getSingleLogoutService();

        public KeyLocator getSignatureValidationKeyLocator();

        public int getMinTimeBetweenDescriptorRequests();

        public HttpClient getClient();

        public static interface SingleLogoutService {
            public boolean validateRequestSignature();

            public boolean validateResponseSignature();

            public boolean signRequest();

            public boolean signResponse();

            public Binding getRequestBinding();

            public Binding getResponseBinding();

            public String getRequestBindingUrl();

            public String getResponseBindingUrl();
        }

        public static interface SingleSignOnService {
            public boolean signRequest();

            public boolean validateResponseSignature();

            public boolean validateAssertionSignature();

            public Binding getRequestBinding();

            public Binding getResponseBinding();

            public String getRequestBindingUrl();

            public URI getAssertionConsumerServiceUrl();
        }
    }

    public static enum Binding {
        POST,
        REDIRECT;


        public static Binding parseBinding(String val) {
            if (val == null) {
                return POST;
            }
            return Binding.valueOf(val);
        }
    }
}

