/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.saml.as7;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.keycloak.subsystem.saml.as7.AllowedClockSkew;
import org.keycloak.subsystem.saml.as7.HttpClientDefinition;
import org.keycloak.subsystem.saml.as7.IdentityProviderDefinition;
import org.keycloak.subsystem.saml.as7.KeyDefinition;
import org.keycloak.subsystem.saml.as7.KeyStoreCertificateDefinition;
import org.keycloak.subsystem.saml.as7.KeyStoreDefinition;
import org.keycloak.subsystem.saml.as7.KeyStorePrivateKeyDefinition;
import org.keycloak.subsystem.saml.as7.KeycloakSamlExtension;
import org.keycloak.subsystem.saml.as7.ServiceProviderDefinition;
import org.keycloak.subsystem.saml.as7.SingleLogoutDefinition;
import org.keycloak.subsystem.saml.as7.SingleSignOnDefinition;

class KeycloakSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    KeycloakSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode addKeycloakSub = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{KeycloakSamlExtension.PATH_SUBSYSTEM}));
        list.add(addKeycloakSub);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            if (reader.getLocalName().equals("secure-deployment")) {
                this.readSecureDeployment(reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private int nextTag(XMLExtendedStreamReader reader) throws XMLStreamException {
        return reader.nextTag();
    }

    void readSecureDeployment(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        String name = this.readRequiredAttribute(reader, "name");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"keycloak-saml"), PathElement.pathElement((String)"secure-deployment", (String)name)});
        ModelNode addSecureDeployment = Util.createAddOperation((PathAddress)addr);
        list.add(addSecureDeployment);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if (tagName.equals("SP")) {
                this.readServiceProvider(reader, list, addr);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readServiceProvider(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parentAddr) throws XMLStreamException {
        String entityId = this.readRequiredAttribute(reader, "entityID");
        PathAddress addr = PathAddress.pathAddress((PathAddress)parentAddr, (PathElement[])new PathElement[]{PathElement.pathElement((String)"SP", (String)entityId)});
        ModelNode addServiceProvider = Util.createAddOperation((PathAddress)addr);
        list.add(addServiceProvider);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("entityID".equals(name)) continue;
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = ServiceProviderDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, addServiceProvider, (XMLStreamReader)reader);
        }
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if ("Keys".equals(tagName)) {
                this.readKeys(list, reader, addr);
                continue;
            }
            if ("PrincipalNameMapping".equals(tagName)) {
                this.readPrincipalNameMapping(addServiceProvider, reader);
                continue;
            }
            if ("RoleIdentifiers".equals(tagName)) {
                this.readRoleIdentifiers(addServiceProvider, reader);
                continue;
            }
            if ("RoleMappingsProvider".equals(tagName)) {
                this.readRoleMappingsProvider(addServiceProvider, reader);
                continue;
            }
            if ("IDP".equals(tagName)) {
                this.readIdentityProvider(list, reader, addr);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readIdentityProvider(List<ModelNode> list, XMLExtendedStreamReader reader, PathAddress parentAddr) throws XMLStreamException {
        String entityId = this.readRequiredAttribute(reader, "entityID");
        PathAddress addr = PathAddress.pathAddress((PathAddress)parentAddr, (PathElement[])new PathElement[]{PathElement.pathElement((String)"IDP", (String)entityId)});
        ModelNode addIdentityProvider = Util.createAddOperation((PathAddress)addr);
        list.add(addIdentityProvider);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("entityID".equals(name) || "encryption".equals(name)) continue;
            SimpleAttributeDefinition attr = IdentityProviderDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, addIdentityProvider, (XMLStreamReader)reader);
        }
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if ("SingleSignOnService".equals(tagName)) {
                this.readSingleSignOn(addIdentityProvider, reader);
                continue;
            }
            if ("SingleLogoutService".equals(tagName)) {
                this.readSingleLogout(addIdentityProvider, reader);
                continue;
            }
            if ("Keys".equals(tagName)) {
                this.readKeys(list, reader, addr);
                continue;
            }
            if ("HttpClient".equals(tagName)) {
                this.readHttpClient(addIdentityProvider, reader);
                continue;
            }
            if ("AllowedClockSkew".equals(tagName)) {
                this.readAllowedClockSkew(addIdentityProvider, reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readSingleSignOn(ModelNode addIdentityProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode sso = addIdentityProvider.get("SingleSignOnService");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = SingleSignOnDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, sso, (XMLStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void readSingleLogout(ModelNode addIdentityProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode slo = addIdentityProvider.get("SingleLogoutService");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = SingleLogoutDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, slo, (XMLStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void readKeys(List<ModelNode> list, XMLExtendedStreamReader reader, PathAddress parentAddr) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedList<ModelNode> keyList = new LinkedList<ModelNode>();
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if (!"Key".equals(tagName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            this.readKey(keyList, reader, parentAddr);
        }
        list.addAll(keyList);
    }

    void readHttpClient(ModelNode addIdentityProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode httpClientNode = addIdentityProvider.get("HttpClient");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = HttpClientDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, httpClientNode, (XMLStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void readAllowedClockSkew(ModelNode addIdentityProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode allowedClockSkew = addIdentityProvider.get("AllowedClockSkew");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (!"unit".equals(name)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            SimpleAttributeDefinition attr = AllowedClockSkew.ALLOWED_CLOCK_SKEW_UNIT;
            attr.parseAndSetParameter(value, allowedClockSkew, (XMLStreamReader)reader);
        }
        String value = reader.getElementText();
        SimpleAttributeDefinition attr = AllowedClockSkew.ALLOWED_CLOCK_SKEW_VALUE;
        attr.parseAndSetParameter(value, allowedClockSkew, (XMLStreamReader)reader);
    }

    void readKey(List<ModelNode> list, XMLExtendedStreamReader reader, PathAddress parentAddr) throws XMLStreamException {
        PathAddress addr = PathAddress.pathAddress((PathAddress)parentAddr, (PathElement[])new PathElement[]{PathElement.pathElement((String)"Key", (String)("key-" + list.size()))});
        ModelNode addKey = Util.createAddOperation((PathAddress)addr);
        list.add(addKey);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = KeyDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, addKey, (XMLStreamReader)reader);
        }
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if ("KeyStore".equals(tagName)) {
                this.readKeyStore(addKey, reader);
                continue;
            }
            if ("PrivateKeyPem".equals(tagName) || "PublicKeyPem".equals(tagName) || "CertificatePem".equals(tagName)) {
                this.readNoAttrElementContent(KeyDefinition.lookupElement(tagName), addKey, reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readNoAttrElementContent(SimpleAttributeDefinition attr, ModelNode model, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        attr.parseAndSetParameter(value, model, (XMLStreamReader)reader);
    }

    void readKeyStore(ModelNode addKey, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addKeyStore = addKey.get("KeyStore");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = KeyStoreDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
        }
        if (!addKeyStore.hasDefined("file") && !addKeyStore.hasDefined("resource")) {
            throw new XMLStreamException("KeyStore element must have 'file' or 'resource' attribute set", reader.getLocation());
        }
        if (!addKeyStore.hasDefined("password")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, KeycloakSubsystemParser.asSet("password"));
        }
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if ("PrivateKey".equals(tagName)) {
                this.readPrivateKey(reader, addKeyStore);
                continue;
            }
            if ("Certificate".equals(tagName)) {
                this.readCertificate(reader, addKeyStore);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readPrivateKey(XMLExtendedStreamReader reader, ModelNode addKeyStore) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = KeyStorePrivateKeyDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
        }
        if (!addKeyStore.hasDefined("PrivateKey-alias")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, KeycloakSubsystemParser.asSet("alias"));
        }
        if (!addKeyStore.hasDefined("PrivateKey-password")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, KeycloakSubsystemParser.asSet("password"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void readCertificate(XMLExtendedStreamReader reader, ModelNode addKeyStore) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            SimpleAttributeDefinition attr = KeyStoreCertificateDefinition.lookup(name);
            if (attr == null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attr.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
        }
        if (!addKeyStore.hasDefined("Certificate-alias")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, KeycloakSubsystemParser.asSet("alias"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void readRoleIdentifiers(ModelNode addServiceProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if (!"Attribute".equals(tagName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String name = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
            ServiceProviderDefinition.ROLE_ATTRIBUTES.parseAndAddParameterElement(name, addServiceProvider, (XMLStreamReader)reader);
        }
    }

    void readRoleMappingsProvider(ModelNode addServiceProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        String providerId = this.readRequiredAttribute(reader, "id");
        ServiceProviderDefinition.ROLE_MAPPINGS_PROVIDER_ID.parseAndSetParameter(providerId, addServiceProvider, (XMLStreamReader)reader);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if (!"Property".equals(tagName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{"name", "value"});
            ServiceProviderDefinition.ROLE_MAPPINGS_PROVIDER_CONFIG.parseAndAddParameterElement(array[0], array[1], addServiceProvider, reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    void readPrincipalNameMapping(ModelNode addServiceProvider, XMLExtendedStreamReader reader) throws XMLStreamException {
        boolean policySet = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("policy".equals(name)) {
                policySet = true;
                ServiceProviderDefinition.PRINCIPAL_NAME_MAPPING_POLICY.parseAndSetParameter(value, addServiceProvider, (XMLStreamReader)reader);
                continue;
            }
            if ("attribute".equals(name)) {
                ServiceProviderDefinition.PRINCIPAL_NAME_MAPPING_ATTRIBUTE_NAME.parseAndSetParameter(value, addServiceProvider, (XMLStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        if (!policySet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, KeycloakSubsystemParser.asSet("policy"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    String readRequiredAttribute(XMLExtendedStreamReader reader, String attrName) throws XMLStreamException {
        String value = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            if (!attr.equals(attrName)) continue;
            value = reader.getAttributeValue(i);
            break;
        }
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(attrName));
        }
        return value;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:keycloak-saml:1.3", false);
        this.writeSecureDeployment(writer, context.getModelNode());
        writer.writeEndElement();
    }

    public void writeSecureDeployment(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.get("secure-deployment").isDefined()) {
            return;
        }
        for (Property sp : model.get("secure-deployment").asPropertyList()) {
            writer.writeStartElement("secure-deployment");
            writer.writeAttribute("name", sp.getName());
            this.writeSps(writer, sp.getValue());
            writer.writeEndElement();
        }
    }

    void writeSps(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.isDefined()) {
            return;
        }
        for (Property sp : model.get("SP").asPropertyList()) {
            writer.writeStartElement("SP");
            writer.writeAttribute("entityID", sp.getName());
            ModelNode spAttributes = sp.getValue();
            for (SimpleAttributeDefinition attr : ServiceProviderDefinition.ATTRIBUTES) {
                attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, spAttributes, false, (XMLStreamWriter)writer);
            }
            this.writeKeys(writer, spAttributes.get("Key"));
            this.writePrincipalNameMapping(writer, spAttributes);
            this.writeRoleIdentifiers(writer, spAttributes);
            this.writeRoleMappingsProvider(writer, spAttributes);
            this.writeIdentityProvider(writer, spAttributes.get("IDP"));
            writer.writeEndElement();
        }
    }

    void writeIdentityProvider(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.isDefined()) {
            return;
        }
        for (Property idp : model.asPropertyList()) {
            writer.writeStartElement("IDP");
            writer.writeAttribute("entityID", idp.getName());
            ModelNode idpAttributes = idp.getValue();
            for (SimpleAttributeDefinition attr : IdentityProviderDefinition.ATTRIBUTES) {
                attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, idpAttributes, false, (XMLStreamWriter)writer);
            }
            this.writeSingleSignOn(writer, idpAttributes.get("SingleSignOnService"));
            this.writeSingleLogout(writer, idpAttributes.get("SingleLogoutService"));
            this.writeKeys(writer, idpAttributes.get("Key"));
            this.writeHttpClient(writer, idpAttributes.get("HttpClient"));
            this.writeAllowedClockSkew(writer, idpAttributes.get("AllowedClockSkew"));
        }
        writer.writeEndElement();
    }

    void writeSingleSignOn(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.isDefined()) {
            return;
        }
        writer.writeStartElement("SingleSignOnService");
        for (SimpleAttributeDefinition attr : SingleSignOnDefinition.ATTRIBUTES) {
            attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, model, false, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    void writeSingleLogout(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.isDefined()) {
            return;
        }
        writer.writeStartElement("SingleLogoutService");
        for (SimpleAttributeDefinition attr : SingleLogoutDefinition.ATTRIBUTES) {
            attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, model, false, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    void writeKeys(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.isDefined()) {
            return;
        }
        boolean contains = false;
        for (Property key : model.asPropertyList()) {
            if (!contains) {
                writer.writeStartElement("Keys");
                contains = true;
            }
            writer.writeStartElement("Key");
            ModelNode keyAttributes = key.getValue();
            for (SimpleAttributeDefinition attr : KeyDefinition.ATTRIBUTES) {
                attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, keyAttributes, false, (XMLStreamWriter)writer);
            }
            for (SimpleAttributeDefinition attr : KeyDefinition.ELEMENTS) {
                attr.getAttributeMarshaller().marshallAsElement((AttributeDefinition)attr, keyAttributes, false, (XMLStreamWriter)writer);
            }
            this.writeKeyStore(writer, keyAttributes.get("KeyStore"));
            writer.writeEndElement();
        }
        if (contains) {
            writer.writeEndElement();
        }
    }

    void writeHttpClient(XMLExtendedStreamWriter writer, ModelNode httpClientModel) throws XMLStreamException {
        if (!httpClientModel.isDefined()) {
            return;
        }
        writer.writeStartElement("HttpClient");
        for (SimpleAttributeDefinition attr : HttpClientDefinition.ATTRIBUTES) {
            attr.marshallAsAttribute(httpClientModel, false, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    void writeAllowedClockSkew(XMLExtendedStreamWriter writer, ModelNode allowedClockSkew) throws XMLStreamException {
        if (!allowedClockSkew.isDefined()) {
            return;
        }
        writer.writeStartElement("AllowedClockSkew");
        AllowedClockSkew.ALLOWED_CLOCK_SKEW_UNIT.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)AllowedClockSkew.ALLOWED_CLOCK_SKEW_UNIT, allowedClockSkew, false, (XMLStreamWriter)writer);
        ModelNode allowedClockSkewValue = allowedClockSkew.get("value");
        char[] chars = allowedClockSkewValue.asString().toCharArray();
        writer.writeCharacters(chars, 0, chars.length);
        writer.writeEndElement();
    }

    void writeKeyStore(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (!model.isDefined()) {
            return;
        }
        writer.writeStartElement("KeyStore");
        for (SimpleAttributeDefinition attr : KeyStoreDefinition.ATTRIBUTES) {
            attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, model, false, (XMLStreamWriter)writer);
        }
        this.writePrivateKey(writer, model);
        this.writeCertificate(writer, model);
        writer.writeEndElement();
    }

    void writeCertificate(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode value = model.get("Certificate-alias");
        if (!value.isDefined()) {
            return;
        }
        writer.writeStartElement("Certificate");
        SimpleAttributeDefinition attr = KeyStoreCertificateDefinition.CERTIFICATE_ALIAS;
        attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, model, false, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    void writePrivateKey(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode pk_alias = model.get("PrivateKey-alias");
        ModelNode pk_password = model.get("PrivateKey-password");
        if (!pk_alias.isDefined() && !pk_password.isDefined()) {
            return;
        }
        writer.writeStartElement("PrivateKey");
        for (SimpleAttributeDefinition attr : KeyStorePrivateKeyDefinition.ATTRIBUTES) {
            attr.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attr, model, false, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    void writeRoleIdentifiers(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode value = model.get("RoleIdentifiers");
        if (!value.isDefined()) {
            return;
        }
        List items = value.asList();
        if (items.size() == 0) {
            return;
        }
        writer.writeStartElement("RoleIdentifiers");
        for (ModelNode item : items) {
            writer.writeStartElement("Attribute");
            writer.writeAttribute("name", item.asString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    void writeRoleMappingsProvider(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode providerId = model.get("roleMappingsProviderId");
        if (!providerId.isDefined()) {
            return;
        }
        writer.writeStartElement("RoleMappingsProvider");
        writer.writeAttribute("id", providerId.asString());
        ServiceProviderDefinition.ROLE_MAPPINGS_PROVIDER_CONFIG.marshallAsElement(model, false, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    void writePrincipalNameMapping(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode policy = model.get("PrincipalNameMapping-policy");
        ModelNode mappingAttribute = model.get("PrincipalNameMapping-attribute-name");
        if (!policy.isDefined() && !mappingAttribute.isDefined()) {
            return;
        }
        writer.writeStartElement("PrincipalNameMapping");
        if (policy.isDefined()) {
            writer.writeAttribute("policy", policy.asString());
        }
        if (mappingAttribute.isDefined()) {
            writer.writeAttribute("attribute", mappingAttribute.asString());
        }
        writer.writeEndElement();
    }

    private static Set<String> asSet(String ... values) {
        HashSet<String> ret = new HashSet<String>();
        for (String value : values) {
            ret.add(value);
        }
        return ret;
    }
}

