/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.OnSessionCreated;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.ecp.EcpAuthenticationHandler;
import org.keycloak.adapters.saml.profile.webbrowsersso.WebBrowserSsoAuthenticationHandler;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;

public abstract class SamlAuthenticator {
    protected static Logger log = Logger.getLogger(SamlAuthenticator.class);
    private final SamlAuthenticationHandler handler;

    public SamlAuthenticator(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        this.handler = this.createAuthenticationHandler(facade, deployment, sessionStore);
    }

    public AuthChallenge getChallenge() {
        return this.handler.getChallenge();
    }

    public AuthOutcome authenticate() {
        log.debugf("SamlAuthenticator is using handler [%s]", (Object)this.handler);
        return this.handler.handle(new OnSessionCreated(){

            @Override
            public void onSessionCreated(SamlSession samlSession) {
                SamlAuthenticator.this.completeAuthentication(samlSession);
            }
        });
    }

    protected abstract void completeAuthentication(SamlSession var1);

    protected SamlAuthenticationHandler createAuthenticationHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        if (EcpAuthenticationHandler.canHandle(facade)) {
            return EcpAuthenticationHandler.create(facade, deployment, sessionStore);
        }
        return this.createBrowserHandler(facade, deployment, sessionStore);
    }

    protected SamlAuthenticationHandler createBrowserHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        return WebBrowserSsoAuthenticationHandler.create(facade, deployment, sessionStore);
    }
}

