/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.writers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyInfoType;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.saml.v2.util.StaxWriterUtil;
import org.w3c.dom.Node;

public class BaseWriter {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static String PROTOCOL_PREFIX = "samlp";
    protected static String ASSERTION_PREFIX = "saml";
    protected XMLStreamWriter writer = null;

    public BaseWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(NameIDType nameIDType, QName tag) throws ProcessingException {
        String value;
        String nameQualifier;
        String spNameQualifier;
        String spProvidedID;
        StaxUtil.writeStartElement(this.writer, tag.getPrefix(), tag.getLocalPart(), tag.getNamespaceURI());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        URI format = nameIDType.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.FORMAT.get(), format.toASCIIString());
        }
        if (StringUtil.isNotNull(spProvidedID = nameIDType.getSPProvidedID())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.SP_PROVIDED_ID.get(), spProvidedID);
        }
        if (StringUtil.isNotNull(spNameQualifier = nameIDType.getSPNameQualifier())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.SP_NAME_QUALIFIER.get(), spNameQualifier);
        }
        if (StringUtil.isNotNull(nameQualifier = nameIDType.getNameQualifier())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NAME_QUALIFIER.get(), nameQualifier);
        }
        if (StringUtil.isNotNull(value = nameIDType.getValue())) {
            StaxUtil.writeCharacters(this.writer, value);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AttributeType attributeType) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeAttributeTypeWithoutRootTag(attributeType);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeAttributeTypeWithoutRootTag(AttributeType attributeType) throws ProcessingException {
        List attributeValues;
        Map otherAttribs;
        String nameFormat;
        String friendlyName;
        String attributeName = attributeType.getName();
        if (attributeName != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NAME.get(), attributeName);
        }
        if (StringUtil.isNotNull(friendlyName = attributeType.getFriendlyName())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.FRIENDLY_NAME.get(), friendlyName);
        }
        if (StringUtil.isNotNull(nameFormat = attributeType.getNameFormat())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NAME_FORMAT.get(), nameFormat);
        }
        if ((otherAttribs = attributeType.getOtherAttributes()) != null) {
            ArrayList<String> nameSpacesDealt = new ArrayList<String>();
            Iterator keySet = otherAttribs.keySet().iterator();
            while (keySet != null && keySet.hasNext()) {
                QName qname = (QName)keySet.next();
                String ns = qname.getNamespaceURI();
                if (!nameSpacesDealt.contains(ns)) {
                    StaxUtil.writeNameSpace(this.writer, qname.getPrefix(), ns);
                    nameSpacesDealt.add(ns);
                }
                String attribValue = (String)otherAttribs.get(qname);
                StaxUtil.writeAttribute(this.writer, qname, attribValue);
            }
        }
        if ((attributeValues = attributeType.getAttributeValue()) != null) {
            for (Object attributeValue : attributeValues) {
                if (attributeValue != null) {
                    if (attributeValue instanceof String) {
                        this.writeStringAttributeValue((String)attributeValue);
                        continue;
                    }
                    if (attributeValue instanceof NameIDType) {
                        this.writeNameIDTypeAttributeValue((NameIDType)attributeValue);
                        continue;
                    }
                    throw logger.writerUnsupportedAttributeValueError(attributeValue.getClass().getName());
                }
                this.writeStringAttributeValue(null);
            }
        }
    }

    public void writeNameIDTypeAttributeValue(NameIDType attributeValue) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE_VALUE.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.write(attributeValue, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
        StaxUtil.writeEndElement(this.writer);
    }

    public void writeStringAttributeValue(String attributeValue) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE_VALUE.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, JBossSAMLURIConstants.XSI_PREFIX.get(), JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "xs", JBossSAMLURIConstants.XMLSCHEMA_NSURI.get());
        StaxUtil.writeAttribute(this.writer, "xsi", JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xs:string");
        if (attributeValue == null) {
            StaxUtil.writeAttribute(this.writer, "xsi", JBossSAMLURIConstants.XSI_NSURI.get(), "nil", "true");
        } else {
            StaxUtil.writeCharacters(this.writer, attributeValue);
        }
        StaxUtil.writeEndElement(this.writer);
    }

    public void writeLocalizedNameType(LocalizedNameType localizedNameType, QName startElement) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, startElement.getPrefix(), startElement.getLocalPart(), startElement.getNamespaceURI());
        StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XML.get(), "lang", "xml"), localizedNameType.getLang());
        StaxUtil.writeCharacters(this.writer, localizedNameType.getValue());
        StaxUtil.writeEndElement(this.writer);
    }

    public void write(SubjectType subject) throws ProcessingException {
        List subjectConfirmations;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.SUBJECT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        SubjectType.STSubType subType = subject.getSubType();
        if (subType != null) {
            EncryptedElementType enc;
            BaseIDAbstractType baseID = subType.getBaseID();
            if (baseID instanceof NameIDType) {
                NameIDType nameIDType = (NameIDType)baseID;
                this.write(nameIDType, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
            }
            if ((enc = subType.getEncryptedID()) != null) {
                throw new RuntimeException("NYI");
            }
            List confirmations = subType.getConfirmation();
            if (confirmations != null) {
                for (SubjectConfirmationType confirmation : confirmations) {
                    this.write(confirmation);
                }
            }
        }
        if ((subjectConfirmations = subject.getConfirmation()) != null) {
            for (SubjectConfirmationType subjectConfirmationType : subjectConfirmations) {
                this.write(subjectConfirmationType);
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(ExtensionsType extensions) throws ProcessingException {
        if (extensions.getAny().isEmpty()) {
            return;
        }
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.EXTENSIONS__PROTOCOL.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        for (Object o : extensions.getAny()) {
            if (o instanceof Node) {
                StaxUtil.writeDOMNode(this.writer, (Node)o);
                continue;
            }
            if (o instanceof SamlProtocolExtensionsAwareBuilder.NodeGenerator) {
                SamlProtocolExtensionsAwareBuilder.NodeGenerator ng = (SamlProtocolExtensionsAwareBuilder.NodeGenerator)o;
                ng.write(this.writer);
                continue;
            }
            throw logger.samlExtensionUnknownChild(o == null ? null : o.getClass());
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    private void write(SubjectConfirmationType subjectConfirmationType) throws ProcessingException {
        SubjectConfirmationDataType subjectConfirmationData;
        NameIDType nameIDType;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.SUBJECT_CONFIRMATION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.METHOD.get(), subjectConfirmationType.getMethod());
        BaseIDAbstractType baseID = subjectConfirmationType.getBaseID();
        if (baseID != null) {
            this.write(baseID);
        }
        if ((nameIDType = subjectConfirmationType.getNameID()) != null) {
            this.write(nameIDType, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
        }
        if ((subjectConfirmationData = subjectConfirmationType.getSubjectConfirmationData()) != null) {
            this.write(subjectConfirmationData);
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void write(SubjectConfirmationDataType subjectConfirmationData) throws ProcessingException {
        String address;
        String recipient;
        XMLGregorianCalendar notOnOrAfter;
        XMLGregorianCalendar notBefore;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        String inResponseTo = subjectConfirmationData.getInResponseTo();
        if (StringUtil.isNotNull(inResponseTo)) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.IN_RESPONSE_TO.get(), inResponseTo);
        }
        if ((notBefore = subjectConfirmationData.getNotBefore()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_BEFORE.get(), notBefore.toString());
        }
        if ((notOnOrAfter = subjectConfirmationData.getNotOnOrAfter()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_ON_OR_AFTER.get(), notOnOrAfter.toString());
        }
        if (StringUtil.isNotNull(recipient = subjectConfirmationData.getRecipient())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.RECIPIENT.get(), recipient);
        }
        if (StringUtil.isNotNull(address = subjectConfirmationData.getAddress())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ADDRESS.get(), address);
        }
        if (subjectConfirmationData instanceof KeyInfoConfirmationDataType) {
            KeyInfoConfirmationDataType kicd = (KeyInfoConfirmationDataType)subjectConfirmationData;
            KeyInfoType keyInfo = (KeyInfoType)kicd.getAnyType();
            StaxWriterUtil.writeKeyInfo(this.writer, keyInfo);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    private void write(BaseIDAbstractType baseId) throws ProcessingException {
        throw logger.notImplementedYet("Method not implemented.");
    }
}

