/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.Serializable;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.keycloak.adapters.spi.KeycloakAccount;

public class SamlSession
implements Serializable,
KeycloakAccount {
    private SamlPrincipal principal;
    private Set<String> roles;
    private String sessionIndex;
    private XMLGregorianCalendar sessionNotOnOrAfter;

    public SamlSession() {
    }

    public SamlSession(SamlPrincipal principal, Set<String> roles, String sessionIndex, XMLGregorianCalendar sessionNotOnOrAfter) {
        this.principal = principal;
        this.roles = roles;
        this.sessionIndex = sessionIndex;
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
    }

    public SamlPrincipal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public XMLGregorianCalendar getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SamlSession)) {
            return false;
        }
        SamlSession otherSession = (SamlSession)other;
        return (this.principal != null ? this.principal.equals((Object)otherSession.principal) : otherSession.principal == null) && (this.roles != null ? this.roles.equals(otherSession.roles) : otherSession.roles == null) && (this.sessionIndex != null ? this.sessionIndex.equals(otherSession.sessionIndex) : otherSession.sessionIndex == null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.sessionIndex == null ? 0 : this.sessionIndex.hashCode());
        return result;
    }
}

