/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.adapters.saml.config.Key;
import org.keycloak.adapters.saml.config.parsers.AbstractKeycloakSamlAdapterV1Parser;
import org.keycloak.adapters.saml.config.parsers.KeyStoreParser;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1QNames;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class KeyParser
extends AbstractKeycloakSamlAdapterV1Parser<Key> {
    private static final KeyParser INSTANCE = new KeyParser();

    private KeyParser() {
        super(KeycloakSamlAdapterV1QNames.KEY);
    }

    public static KeyParser getInstance() {
        return INSTANCE;
    }

    protected Key instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        Key key = new Key();
        key.setSigning(StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_SIGNING));
        key.setEncryption(StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ENCRYPTION));
        return key;
    }

    protected void processSubElement(XMLEventReader xmlEventReader, Key target, KeycloakSamlAdapterV1QNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case KEY_STORE: {
                target.setKeystore((Key.KeyStoreConfig)KeyStoreParser.getInstance().parse(xmlEventReader));
                break;
            }
            case CERTIFICATE_PEM: {
                StaxParserUtil.advance((XMLEventReader)xmlEventReader);
                String value = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                target.setCertificatePem(StringPropertyReplacer.replaceProperties((String)value));
                break;
            }
            case PUBLIC_KEY_PEM: {
                StaxParserUtil.advance((XMLEventReader)xmlEventReader);
                String value = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                target.setPublicKeyPem(StringPropertyReplacer.replaceProperties((String)value));
                break;
            }
            case PRIVATE_KEY_PEM: {
                StaxParserUtil.advance((XMLEventReader)xmlEventReader);
                String value = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                target.setPrivateKeyPem(StringPropertyReplacer.replaceProperties((String)value));
            }
        }
    }
}

