/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.keycloak.adapters.saml.CatalinaSamlAuthenticator;
import org.keycloak.adapters.saml.CatalinaSamlSessionStore;
import org.keycloak.adapters.saml.DefaultSamlDeployment;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.tomcat.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;
import org.keycloak.saml.common.exceptions.ParsingException;

public abstract class AbstractSamlAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    private static final Logger log = Logger.getLogger("" + AbstractSamlAuthenticatorValve.class);
    protected CatalinaUserSessionManagement userSessionManagement = new CatalinaUserSessionManagement();
    protected SamlDeploymentContext deploymentContext;
    protected SessionIdMapper mapper = new InMemorySessionIdMapper();

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.cache = false;
        } else if ("after_start".equals(event.getType())) {
            this.keycloakInit();
        } else if (event.getType() == "before_stop") {
            this.beforeStop();
        }
    }

    protected void logoutInternal(Request request) {
        CatalinaHttpFacade facade = new CatalinaHttpFacade(null, request);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        SamlSessionStore tokenStore = this.getTokenStore(request, (HttpFacade)facade, deployment);
        tokenStore.logoutAccount();
        request.setUserPrincipal(null);
    }

    public void keycloakInit() {
        block7: {
            DefaultSamlDeployment deployment;
            String configResolverClass = this.context.getServletContext().getInitParameter("keycloak.config.resolver");
            if (configResolverClass != null) {
                try {
                    throw new RuntimeException("Not implemented yet");
                }
                catch (Exception ex) {
                    log.log(Level.FINE, "The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
                    break block7;
                }
            }
            InputStream is = AbstractSamlAuthenticatorValve.getConfigInputStream(this.context);
            if (is == null) {
                log.info("No adapter configuration. Keycloak is unconfigured and will deny all requests.");
                deployment = new DefaultSamlDeployment();
            } else {
                try {
                    ResourceLoader loader = new ResourceLoader(){

                        public InputStream getResourceAsStream(String resource) {
                            return AbstractSamlAuthenticatorValve.this.context.getServletContext().getResourceAsStream(resource);
                        }
                    };
                    deployment = new DeploymentBuilder().build(is, loader);
                }
                catch (ParsingException e) {
                    throw new RuntimeException(e);
                }
            }
            this.deploymentContext = new SamlDeploymentContext((SamlDeployment)deployment);
            log.fine("Keycloak is using a per-deployment configuration.");
        }
        this.context.getServletContext().setAttribute(SamlDeploymentContext.class.getName(), (Object)this.deploymentContext);
    }

    protected void beforeStop() {
    }

    private static InputStream getConfigFromServletContext(ServletContext servletContext) {
        String xml = servletContext.getInitParameter("org.keycloak.saml.xml.adapterConfig");
        if (xml == null) {
            return null;
        }
        log.finest("**** using org.keycloak.saml.xml.adapterConfig");
        log.finest(xml);
        return new ByteArrayInputStream(xml.getBytes());
    }

    private static InputStream getConfigInputStream(Context context) {
        InputStream is = AbstractSamlAuthenticatorValve.getConfigFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.fine("**** using /WEB-INF/keycloak-saml.xml");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak-saml.xml");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    log.log(Level.SEVERE, "NOT FOUND {0}", path);
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        log.fine("*********************** SAML ************");
        super.invoke(request, response);
    }

    protected abstract GenericPrincipalFactory createPrincipalFactory();

    protected abstract boolean forwardToErrorPageInternal(Request var1, HttpServletResponse var2, Object var3) throws IOException;

    protected void forwardToLogoutPage(Request request, HttpServletResponse response, SamlDeployment deployment) {
        RequestDispatcher disp = request.getRequestDispatcher(deployment.getLogoutPage());
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean authenticateInternal(Request request, HttpServletResponse response, Object loginConfig) throws IOException {
        log.fine("authenticateInternal");
        CatalinaHttpFacade facade = new CatalinaHttpFacade(response, request);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            log.fine("deployment not configured");
            return false;
        }
        SamlSessionStore tokenStore = this.getTokenStore(request, (HttpFacade)facade, deployment);
        CatalinaSamlAuthenticator authenticator = new CatalinaSamlAuthenticator((HttpFacade)facade, deployment, tokenStore);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            log.fine("AUTHENTICATED");
            return !facade.isEnded();
        }
        if (outcome == AuthOutcome.LOGGED_OUT) {
            this.logoutInternal(request);
            if (deployment.getLogoutPage() != null) {
                this.forwardToLogoutPage(request, response, deployment);
            }
            log.fine("Logging OUT");
            return false;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            log.fine("challenge");
            if (loginConfig == null) {
                loginConfig = request.getContext().getLoginConfig();
            }
            challenge.challenge((HttpFacade)facade);
        }
        return false;
    }

    public void keycloakSaveRequest(Request request) throws IOException {
        this.saveRequest(request, request.getSessionInternal(true));
    }

    public boolean keycloakRestoreRequest(Request request) {
        try {
            return this.restoreRequest(request, request.getSessionInternal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected SamlSessionStore getTokenStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        SamlSessionStore store = (SamlSessionStore)request.getNote(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        store = new CatalinaSamlSessionStore(this.userSessionManagement, this.createPrincipalFactory(), this.mapper, request, this, facade);
        request.setNote(TOKEN_STORE_NOTE, (Object)store);
        return store;
    }
}

