/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletSessionConfig;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.DefaultSamlDeployment;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.adapters.saml.undertow.ServletSamlAuthMech;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.saml.common.exceptions.ParsingException;

public class SamlServletExtension
implements ServletExtension {
    protected static Logger log = Logger.getLogger(SamlServletExtension.class);

    public boolean isAuthenticationMechanismPresent(DeploymentInfo deploymentInfo, String mechanismName) {
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        if (loginConfig != null) {
            for (AuthMethodConfig method : loginConfig.getAuthMethods()) {
                if (!method.getName().equalsIgnoreCase(mechanismName)) continue;
                return true;
            }
        }
        return false;
    }

    private static InputStream getXMLFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.saml.xml.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }

    private static InputStream getConfigInputStream(ServletContext context) {
        InputStream is = SamlServletExtension.getXMLFromServletContext(context);
        if (is == null) {
            String path = context.getInitParameter("keycloak.config.file");
            if (path == null) {
                log.debug((Object)"using /WEB-INF/keycloak-saml.xml");
                is = context.getResourceAsStream("/WEB-INF/keycloak-saml.xml");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, final ServletContext servletContext) {
        SamlDeploymentContext deploymentContext;
        block8: {
            DefaultSamlDeployment deployment;
            if (!this.isAuthenticationMechanismPresent(deploymentInfo, "KEYCLOAK-SAML")) {
                log.debug((Object)"auth-method is not keycloak saml!");
                return;
            }
            log.debug((Object)"SamlServletException initialization");
            String configResolverClass = servletContext.getInitParameter("keycloak.config.resolver");
            deploymentContext = null;
            if (configResolverClass != null) {
                try {
                    throw new RuntimeException("Not implemented yet");
                }
                catch (Exception ex) {
                    log.warn((Object)("The specified resolver " + configResolverClass + " could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: " + ex.getMessage()));
                    break block8;
                }
            }
            InputStream is = SamlServletExtension.getConfigInputStream(servletContext);
            if (is == null) {
                log.warn((Object)"No adapter configuration.  Keycloak is unconfigured and will deny all requests.");
                deployment = new DefaultSamlDeployment();
            } else {
                try {
                    ResourceLoader loader = new ResourceLoader(){

                        public InputStream getResourceAsStream(String resource) {
                            return servletContext.getResourceAsStream(resource);
                        }
                    };
                    deployment = new DeploymentBuilder().build(is, loader);
                }
                catch (ParsingException e) {
                    throw new RuntimeException(e);
                }
            }
            deploymentContext = new SamlDeploymentContext((SamlDeployment)deployment);
            log.debug((Object)"Keycloak is using a per-deployment configuration.");
        }
        servletContext.setAttribute(SamlDeploymentContext.class.getName(), (Object)deploymentContext);
        UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement();
        final ServletSamlAuthMech mech = this.createAuthMech(deploymentInfo, deploymentContext, userSessionManagement);
        deploymentInfo.addAuthenticationMechanism("KEYCLOAK-SAML", new AuthenticationMechanismFactory(){

            public AuthenticationMechanism create(String s, FormParserFactory formParserFactory, Map<String, String> stringStringMap) {
                return mech;
            }
        });
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }

            public Account verify(Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }
        });
        log.debug((Object)("Setting jsession cookie path to: " + deploymentInfo.getContextPath()));
        ServletSessionConfig cookieConfig = new ServletSessionConfig();
        cookieConfig.setPath(deploymentInfo.getContextPath());
        deploymentInfo.setServletSessionConfig(cookieConfig);
    }

    protected ServletSamlAuthMech createAuthMech(DeploymentInfo deploymentInfo, SamlDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement) {
        return new ServletSamlAuthMech(deploymentContext, userSessionManagement, this.getErrorPage(deploymentInfo));
    }

    protected String getErrorPage(DeploymentInfo deploymentInfo) {
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        String errorPage = null;
        if (loginConfig != null) {
            errorPage = loginConfig.getErrorPage();
        }
        return errorPage;
    }
}

