/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class Configuration {
    static Configuration INSTANCE = new Configuration();
    private ModelNode config = new ModelNode();

    private Configuration() {
    }

    void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.updateModel(operation, model, false);
    }

    void updateModel(ModelNode operation, ModelNode model, boolean checkSingleton) throws OperationFailedException {
        ModelNode node = this.config;
        List addressNodes = operation.get("address").asPropertyList();
        int lastIndex = addressNodes.size() - 1;
        for (int i = 0; i < addressNodes.size(); ++i) {
            Property addressNode = (Property)addressNodes.get(i);
            if (i == lastIndex && checkSingleton && node.get(addressNode.getName()).isDefined()) {
                throw new OperationFailedException("Duplicate resource: " + addressNode.getName());
            }
            node = node.get(addressNode.getName()).get(addressNode.getValue().asString());
        }
        node.set(model);
    }

    public ModelNode getSecureDeployment(DeploymentUnit deploymentUnit) {
        String name = this.preferredDeploymentName(deploymentUnit);
        ModelNode secureDeployment = this.config.get("subsystem").get("keycloak-saml").get("secure-deployment");
        if (secureDeployment.hasDefined(name)) {
            return secureDeployment.get(name);
        }
        return null;
    }

    private String preferredDeploymentName(DeploymentUnit deploymentUnit) {
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return deploymentName;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return deploymentName;
        }
        String moduleName = webMetaData.getModuleName();
        if (moduleName != null) {
            return moduleName + ".war";
        }
        return deploymentName;
    }
}

