/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import java.security.Principal;
import java.util.Set;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.webbrowsersso.BrowserHandler;
import org.keycloak.adapters.spi.HttpFacade;

public class UndertowSamlAuthenticator
extends SamlAuthenticator {
    protected SecurityContext securityContext;

    public UndertowSamlAuthenticator(SecurityContext securityContext, HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        super(facade, deployment, sessionStore);
        this.securityContext = securityContext;
    }

    protected void completeAuthentication(final SamlSession samlSession) {
        Account undertowAccount = new Account(){

            public Principal getPrincipal() {
                return samlSession.getPrincipal();
            }

            public Set<String> getRoles() {
                return samlSession.getRoles();
            }
        };
        this.securityContext.authenticationComplete(undertowAccount, "KEYCLOAK-SAML", false);
    }

    protected SamlAuthenticationHandler createBrowserHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        return new BrowserHandler(facade, deployment, sessionStore);
    }
}

