/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.keycloak.adapters.undertow.ChangeSessionId;
import org.keycloak.adapters.undertow.SavedRequest;
import org.keycloak.adapters.undertow.ServletHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.common.util.KeycloakUriBuilder;

public class ServletSamlSessionStore
implements SamlSessionStore {
    protected static Logger log = Logger.getLogger(SamlSessionStore.class);
    public static final String SAML_REDIRECT_URI = "SAML_REDIRECT_URI";
    private final HttpServerExchange exchange;
    private final UndertowUserSessionManagement sessionManagement;
    private final SecurityContext securityContext;
    private final SessionIdMapper idMapper;
    private final SessionIdMapperUpdater idMapperUpdater;
    protected final SamlDeployment deployment;

    public ServletSamlSessionStore(HttpServerExchange exchange, UndertowUserSessionManagement sessionManagement, SecurityContext securityContext, SessionIdMapper idMapper, SessionIdMapperUpdater idMapperUpdater, SamlDeployment deployment) {
        this.exchange = exchange;
        this.sessionManagement = sessionManagement;
        this.securityContext = securityContext;
        this.idMapper = idMapper;
        this.deployment = deployment;
        this.idMapperUpdater = idMapperUpdater;
    }

    public void setCurrentAction(SamlSessionStore.CurrentAction action) {
        if (action == SamlSessionStore.CurrentAction.NONE && this.getRequest().getSession(false) == null) {
            return;
        }
        this.getRequest().getSession().setAttribute("SAML_CURRENT_ACTION", (Object)action);
    }

    public boolean isLoggingIn() {
        HttpSession session = this.getRequest().getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_IN;
    }

    public boolean isLoggingOut() {
        HttpSession session = this.getRequest().getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_OUT;
    }

    public void logoutAccount() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            SamlSession samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName());
            if (samlSession != null) {
                if (samlSession.getSessionIndex() != null) {
                    this.idMapperUpdater.removeSession(this.idMapper, session.getId());
                }
                session.removeAttribute(SamlSession.class.getName());
            }
            session.removeAttribute(SAML_REDIRECT_URI);
        }
    }

    public void logoutByPrincipal(String principal) {
        Set sessions = this.idMapper.getUserSessions(principal);
        if (sessions != null) {
            LinkedList<String> ids = new LinkedList<String>();
            ids.addAll(sessions);
            this.logoutSessionIds(ids);
            for (String id : ids) {
                this.idMapperUpdater.removeSession(this.idMapper, id);
            }
        }
    }

    public void logoutBySsoId(List<String> ssoIds) {
        if (ssoIds == null) {
            return;
        }
        LinkedList<String> sessionIds = new LinkedList<String>();
        for (String id : ssoIds) {
            String sessionId = this.idMapper.getSessionFromSSO(id);
            if (sessionId == null) continue;
            sessionIds.add(sessionId);
            this.idMapperUpdater.removeSession(this.idMapper, sessionId);
        }
        this.logoutSessionIds(sessionIds);
    }

    protected void logoutSessionIds(List<String> sessionIds) {
        if (sessionIds == null || sessionIds.isEmpty()) {
            return;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        SessionManager sessionManager = servletRequestContext.getDeployment().getSessionManager();
        this.sessionManagement.logoutHttpSessions(sessionManager, sessionIds);
    }

    public boolean isLoggedIn() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        final SamlSession samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName());
        if (samlSession == null) {
            log.debug((Object)"SamlSession was not in session, returning null");
            return false;
        }
        Account undertowAccount = new Account(){

            public Principal getPrincipal() {
                return samlSession.getPrincipal();
            }

            public Set<String> getRoles() {
                return samlSession.getRoles();
            }
        };
        this.securityContext.authenticationComplete(undertowAccount, "KEYCLOAK-SAML", false);
        this.restoreRequest();
        return true;
    }

    public void saveAccount(SamlSession account) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSession session = this.getSession(true);
        session.setAttribute(SamlSession.class.getName(), (Object)account);
        this.sessionManagement.login(servletRequestContext.getDeployment().getSessionManager());
        String sessionId = this.changeSessionId(session);
        this.idMapperUpdater.map(this.idMapper, account.getSessionIndex(), account.getPrincipal().getSamlSubject(), sessionId);
    }

    protected String changeSessionId(HttpSession session) {
        if (!this.deployment.turnOffChangeSessionIdOnLogin()) {
            return ChangeSessionId.changeSessionId((HttpServerExchange)this.exchange, (boolean)false);
        }
        return session.getId();
    }

    public SamlSession getAccount() {
        HttpSession session = this.getSession(true);
        return (SamlSession)session.getAttribute(SamlSession.class.getName());
    }

    public String getRedirectUri() {
        ServletRequestContext sc = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSessionImpl session = sc.getCurrentServletContext().getSession(this.exchange, true);
        String redirect = (String)session.getAttribute(SAML_REDIRECT_URI);
        if (redirect == null) {
            ServletHttpFacade facade = new ServletHttpFacade(this.exchange);
            HttpServletRequest req = (HttpServletRequest)sc.getServletRequest();
            String contextPath = req.getContextPath();
            String baseUri = KeycloakUriBuilder.fromUri((String)req.getRequestURL().toString()).replacePath(contextPath).build(new Object[0]).toString();
            return SamlUtil.getRedirectTo((HttpFacade)facade, (String)contextPath, (String)baseUri);
        }
        return redirect;
    }

    public void saveRequest() {
        SavedRequest.trySaveRequest((HttpServerExchange)this.exchange);
        ServletRequestContext sc = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSessionImpl session = sc.getCurrentServletContext().getSession(this.exchange, true);
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)this.exchange.getRequestURI()).replaceQuery(this.exchange.getQueryString());
        if (!this.exchange.isHostIncludedInRequestURI()) {
            uriBuilder.scheme(this.exchange.getRequestScheme()).host(this.exchange.getHostAndPort());
        }
        String uri = uriBuilder.build(new Object[0]).toString();
        session.setAttribute(SAML_REDIRECT_URI, (Object)uri);
    }

    public boolean restoreRequest() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return false;
        }
        SavedRequest.tryRestoreRequest((HttpServerExchange)this.exchange, (HttpSession)session);
        session.removeAttribute(SAML_REDIRECT_URI);
        return false;
    }

    protected HttpSession getSession(boolean create) {
        HttpServletRequest req = this.getRequest();
        return req.getSession(create);
    }

    private HttpServletResponse getResponse() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return (HttpServletResponse)servletRequestContext.getServletResponse();
    }

    private HttpServletRequest getRequest() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return (HttpServletRequest)servletRequestContext.getServletRequest();
    }
}

