/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;

public class SAMLExtensionsParser
implements ParserNamespaceSupport {
    private static final String EXTENSIONS = JBossSAMLConstants.EXTENSIONS.get();
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public ExtensionsType parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, EXTENSIONS);
        ExtensionsType extensions = new ExtensionsType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches(endElement, EXTENSIONS)) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName(endElement));
            }
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            extensions.addExtension((Object)StaxParserUtil.getDOMElement(xmlEventReader));
        }
        return extensions;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.PROTOCOL_NSURI.get()) && localPart.equals(JBossSAMLConstants.EXTENSIONS.get());
    }
}

