/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.cert.X509Certificate;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.elytron.ElytronSamlSessionStore;
import org.keycloak.adapters.saml.elytron.ElytronTokeStore;
import org.keycloak.adapters.saml.elytron.SecurityIdentityUtil;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;

class ElytronHttpFacade
implements HttpFacade {
    private final HttpServerRequest request;
    private final CallbackHandler callbackHandler;
    private final SamlDeploymentContext deploymentContext;
    private final SamlSessionStore sessionStore;
    private Consumer<HttpServerResponse> responseConsumer;
    private SecurityIdentity securityIdentity;
    private boolean restored;
    private SamlSession samlSession;

    public ElytronHttpFacade(HttpServerRequest request, SessionIdMapper idMapper, SamlDeploymentContext deploymentContext, CallbackHandler handler) {
        this.request = request;
        this.deploymentContext = deploymentContext;
        this.callbackHandler = handler;
        this.responseConsumer = response -> {};
        this.sessionStore = this.createTokenStore(idMapper);
    }

    private SamlSessionStore createTokenStore(SessionIdMapper idMapper) {
        return new ElytronSamlSessionStore(this, idMapper, this.getDeployment());
    }

    void authenticationComplete(SamlSession samlSession) {
        this.samlSession = samlSession;
    }

    void authenticationComplete() {
        this.securityIdentity = SecurityIdentityUtil.authorize(this.callbackHandler, this.samlSession.getPrincipal());
        if (this.securityIdentity != null) {
            this.request.authenticationComplete(response -> {
                if (!this.restored) {
                    this.responseConsumer.accept(response);
                }
            }, () -> ((ElytronTokeStore)this.sessionStore).logout(true));
        }
    }

    void authenticationCompleteAnonymous() {
        try {
            AnonymousAuthorizationCallback anonymousAuthorizationCallback = new AnonymousAuthorizationCallback(null);
            this.callbackHandler.handle(new Callback[]{anonymousAuthorizationCallback});
            if (anonymousAuthorizationCallback.isAuthorized()) {
                this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED, new SecurityIdentityCallback()});
                this.request.authenticationComplete(response -> response.forward(this.getRequest().getRelativePath()));
            } else {
                this.request.noAuthenticationInProgress(response -> response.forward(this.getRequest().getRelativePath()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error processing callbacks during logout.", e);
        }
    }

    void authenticationFailed() {
        this.request.authenticationFailed("Authentication Failed", response -> this.responseConsumer.accept(response));
    }

    void noAuthenticationInProgress(AuthChallenge challenge) {
        if (challenge != null) {
            challenge.challenge((HttpFacade)this);
        }
        this.request.noAuthenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    void authenticationInProgress() {
        this.request.authenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    HttpScope getScope(Scope scope) {
        return this.request.getScope(scope);
    }

    HttpScope getScope(Scope scope, String id) {
        return this.request.getScope(scope, id);
    }

    Collection<String> getScopeIds(Scope scope) {
        return this.request.getScopeIds(scope);
    }

    SamlDeployment getDeployment() {
        return this.deploymentContext.resolveDeployment((HttpFacade)this);
    }

    public HttpFacade.Request getRequest() {
        return new HttpFacade.Request(){

            public String getMethod() {
                return ElytronHttpFacade.this.request.getRequestMethod();
            }

            public String getURI() {
                try {
                    return URLDecoder.decode(ElytronHttpFacade.this.request.getRequestURI().toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Failed to decode request URI", e);
                }
            }

            public String getRelativePath() {
                return ElytronHttpFacade.this.request.getRequestPath();
            }

            public boolean isSecure() {
                return ElytronHttpFacade.this.request.getRequestURI().getScheme().equals("https");
            }

            public String getFirstParam(String param) {
                return ElytronHttpFacade.this.request.getFirstParameterValue(param);
            }

            public String getQueryParamValue(String param) {
                return ElytronHttpFacade.this.request.getFirstParameterValue(param);
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                List cookies = ElytronHttpFacade.this.request.getCookies();
                if (cookies != null) {
                    for (HttpServerCookie cookie : cookies) {
                        if (!cookie.getName().equals(cookieName)) continue;
                        return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
                    }
                }
                return null;
            }

            public String getHeader(String name) {
                return ElytronHttpFacade.this.request.getFirstRequestHeaderValue(name);
            }

            public List<String> getHeaders(String name) {
                return ElytronHttpFacade.this.request.getRequestHeaderValues(name);
            }

            public InputStream getInputStream() {
                return ElytronHttpFacade.this.request.getInputStream();
            }

            public String getRemoteAddr() {
                InetSocketAddress sourceAddress = ElytronHttpFacade.this.request.getSourceAddress();
                if (sourceAddress == null) {
                    return "";
                }
                InetAddress address = sourceAddress.getAddress();
                if (address == null) {
                    return sourceAddress.getHostString();
                }
                return address.getHostAddress();
            }

            public void setError(AuthenticationError error) {
                ElytronHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(AuthenticationError.class.getName(), (Object)error);
            }

            public void setError(LogoutError error) {
                ElytronHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(LogoutError.class.getName(), (Object)error);
            }
        };
    }

    public HttpFacade.Response getResponse() {
        return new HttpFacade.Response(){

            public void setStatus(int status) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> response.setStatusCode(status));
            }

            public void addHeader(String name, String value) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> response.addResponseHeader(name, value));
            }

            public void setHeader(String name, String value) {
                this.addHeader(name, value);
            }

            public void resetCookie(String name, String path) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, "", path, null, 0, false, false, (HttpServerResponse)response));
            }

            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, value, path, domain, maxAge, secure, httpOnly, (HttpServerResponse)response));
            }

            private void setCookie(final String name, final String value, final String path, final String domain, final int maxAge, final boolean secure, final boolean httpOnly, HttpServerResponse response) {
                response.setResponseCookie(new HttpServerCookie(){

                    public String getName() {
                        return name;
                    }

                    public String getValue() {
                        return value;
                    }

                    public String getDomain() {
                        return domain;
                    }

                    public int getMaxAge() {
                        return maxAge;
                    }

                    public String getPath() {
                        return path;
                    }

                    public boolean isSecure() {
                        return secure;
                    }

                    public int getVersion() {
                        return 0;
                    }

                    public boolean isHttpOnly() {
                        return httpOnly;
                    }
                });
            }

            public OutputStream getOutputStream() {
                final ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(new Consumer<HttpServerResponse>(){

                    @Override
                    public void accept(HttpServerResponse httpServerResponse) {
                        try {
                            httpServerResponse.getOutputStream().write(stream.toByteArray());
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to write to response output stream", e);
                        }
                    }
                });
                return stream;
            }

            public void sendError(int code) {
                this.setStatus(code);
            }

            public void sendError(int code, String message) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> {
                    response.setStatusCode(code);
                    response.addResponseHeader("Content-Type", "text/html");
                    try {
                        response.getOutputStream().write(message.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            public void end() {
            }
        };
    }

    public X509Certificate[] getCertificateChain() {
        return new X509Certificate[0];
    }

    public boolean restoreRequest() {
        this.restored = this.request.resumeRequest();
        return this.restored;
    }

    public void suspendRequest() {
        this.responseConsumer = this.responseConsumer.andThen(httpServerResponse -> this.request.suspendRequest());
    }

    public boolean isAuthorized() {
        return this.securityIdentity != null;
    }

    public URI getURI() {
        return this.request.getRequestURI();
    }

    public SamlSessionStore getSessionStore() {
        return this.sessionStore;
    }
}

