/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.SAML2NameIDBuilder;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Document;

public class SAML2ErrorResponseBuilder
implements SamlProtocolExtensionsAwareBuilder<SAML2ErrorResponseBuilder> {
    protected String status;
    protected String destination;
    protected NameIDType issuer;
    protected final List<SamlProtocolExtensionsAwareBuilder.NodeGenerator> extensions = new LinkedList<SamlProtocolExtensionsAwareBuilder.NodeGenerator>();

    public SAML2ErrorResponseBuilder status(String status) {
        this.status = status;
        return this;
    }

    public SAML2ErrorResponseBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2ErrorResponseBuilder issuer(NameIDType issuer) {
        this.issuer = issuer;
        return this;
    }

    public SAML2ErrorResponseBuilder issuer(String issuer) {
        return this.issuer(SAML2NameIDBuilder.value(issuer).build());
    }

    @Override
    public SAML2ErrorResponseBuilder addExtension(SamlProtocolExtensionsAwareBuilder.NodeGenerator extension) {
        this.extensions.add(extension);
        return this;
    }

    public Document buildDocument() throws ProcessingException {
        try {
            ResponseType statusResponse = new ResponseType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
            statusResponse.setStatus(JBossSAMLAuthnResponseFactory.createStatusTypeForResponder(this.status));
            statusResponse.setIssuer(this.issuer);
            statusResponse.setDestination(this.destination);
            if (!this.extensions.isEmpty()) {
                ExtensionsType extensionsType = new ExtensionsType();
                for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : this.extensions) {
                    extensionsType.addExtension((Object)extension);
                }
                statusResponse.setExtensions(extensionsType);
            }
            SAML2Response saml2Response = new SAML2Response();
            return saml2Response.convert((StatusResponseType)statusResponse);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (ParsingException e) {
            throw new ProcessingException((Throwable)e);
        }
    }
}

