/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.rotation;

import java.security.Key;
import java.security.KeyManagementException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.adapters.cloned.HttpAdapterUtils;
import org.keycloak.adapters.cloned.HttpClientAdapterException;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.processing.api.util.KeyInfoTools;

public class SamlDescriptorPublicKeyLocator
implements KeyLocator,
Iterable<PublicKey> {
    private static final Logger LOG = Logger.getLogger(SamlDescriptorPublicKeyLocator.class);
    private final int minTimeBetweenDescriptorRequests;
    private final int cacheEntryTtl;
    private final String descriptorUrl;
    private final Map<String, PublicKey> publicKeyCache = new ConcurrentHashMap<String, PublicKey>();
    private final HttpClient client;
    private volatile int lastRequestTime = 0;

    public SamlDescriptorPublicKeyLocator(String descriptorUrl, int minTimeBetweenDescriptorRequests, int cacheEntryTtl, HttpClient httpClient) {
        this.minTimeBetweenDescriptorRequests = minTimeBetweenDescriptorRequests <= 0 ? 20 : minTimeBetweenDescriptorRequests;
        this.descriptorUrl = descriptorUrl;
        this.cacheEntryTtl = cacheEntryTtl;
        this.client = httpClient;
    }

    public Key getKey(String kid) throws KeyManagementException {
        PublicKey res;
        if (kid == null) {
            LOG.debugf("Invalid key id: %s", (Object)kid);
            return null;
        }
        LOG.tracef("Requested key id: %s", (Object)kid);
        int currentTime = Time.currentTime();
        if (currentTime > this.lastRequestTime + this.cacheEntryTtl) {
            LOG.debugf("Performing regular cache cleanup.", new Object[0]);
            res = this.refreshCertificateCacheAndGet(kid);
        } else {
            res = this.publicKeyCache.get(kid);
            if (res == null) {
                if (currentTime > this.lastRequestTime + this.minTimeBetweenDescriptorRequests) {
                    res = this.refreshCertificateCacheAndGet(kid);
                } else {
                    LOG.debugf("Won't send request to realm SAML descriptor url, timeout not expired. Last request time was %d", this.lastRequestTime);
                }
            }
        }
        return res;
    }

    public synchronized void refreshKeyCache() {
        LOG.info((Object)"Forcing key cache cleanup and refresh.");
        this.publicKeyCache.clear();
        this.refreshCertificateCacheAndGet(null);
    }

    private synchronized PublicKey refreshCertificateCacheAndGet(String kid) {
        List signingCerts;
        if (this.descriptorUrl == null) {
            return null;
        }
        this.lastRequestTime = Time.currentTime();
        LOG.debugf("Refreshing public key cache from %s", (Object)this.descriptorUrl);
        try {
            MultivaluedHashMap<String, KeyInfo> certs = HttpAdapterUtils.downloadKeysFromSamlDescriptor(this.client, this.descriptorUrl);
            signingCerts = (List)certs.get((Object)KeyTypes.SIGNING.value());
        }
        catch (HttpClientAdapterException ex) {
            LOG.error((Object)"Could not refresh certificates from the server", (Throwable)ex);
            return null;
        }
        if (signingCerts == null) {
            return null;
        }
        LOG.debugf("Certificates retrieved from server, filling public key cache", new Object[0]);
        this.publicKeyCache.clear();
        for (KeyInfo ki : signingCerts) {
            KeyName keyName = KeyInfoTools.getKeyName((KeyInfo)ki);
            X509Certificate x509certificate = KeyInfoTools.getX509Certificate((KeyInfo)ki);
            if (x509certificate != null && keyName != null) {
                LOG.tracef("Registering signing certificate %s", (Object)keyName.getName());
                this.publicKeyCache.put(keyName.getName(), x509certificate.getPublicKey());
                continue;
            }
            LOG.tracef("Ignoring certificate %s: %s", (Object)keyName, (Object)x509certificate);
        }
        return kid == null ? null : this.publicKeyCache.get(kid);
    }

    public String toString() {
        return "Keys retrieved from SAML descriptor at " + this.descriptorUrl;
    }

    @Override
    public Iterator<PublicKey> iterator() {
        if (this.publicKeyCache.isEmpty()) {
            this.refreshCertificateCacheAndGet(null);
        }
        return this.publicKeyCache.values().iterator();
    }
}

