/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.adapters.saml.config.IDP;
import org.keycloak.adapters.saml.config.SP;
import org.keycloak.adapters.saml.config.parsers.AbstractKeycloakSamlAdapterV1Parser;
import org.keycloak.adapters.saml.config.parsers.IdpParser;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1QNames;
import org.keycloak.adapters.saml.config.parsers.KeysParser;
import org.keycloak.adapters.saml.config.parsers.PrincipalNameMappingParser;
import org.keycloak.adapters.saml.config.parsers.RoleMappingParser;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class SpParser
extends AbstractKeycloakSamlAdapterV1Parser<SP> {
    private static final SpParser INSTANCE = new SpParser();

    private SpParser() {
        super(KeycloakSamlAdapterV1QNames.SP);
    }

    public static SpParser getInstance() {
        return INSTANCE;
    }

    protected SP instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        SP sp = new SP();
        sp.setEntityID(StaxParserUtil.getRequiredAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ENTITY_ID));
        sp.setSslPolicy(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_SSL_POLICY));
        sp.setLogoutPage(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_LOGOUT_PAGE));
        sp.setNameIDPolicyFormat(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_NAME_ID_POLICY_FORMAT));
        sp.setForceAuthentication(StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_FORCE_AUTHENTICATION));
        sp.setIsPassive(StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_IS_PASSIVE));
        sp.setAutodetectBearerOnly(StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_AUTODETECT_BEARER_ONLY));
        sp.setTurnOffChangeSessionIdOnLogin(StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_TURN_OFF_CHANGE_SESSSION_ID_ON_LOGIN));
        return sp;
    }

    protected void processSubElement(XMLEventReader xmlEventReader, SP target, KeycloakSamlAdapterV1QNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case KEYS: {
                target.setKeys((List)KeysParser.getInstance().parse(xmlEventReader));
                break;
            }
            case PRINCIPAL_NAME_MAPPING: {
                target.setPrincipalNameMapping((SP.PrincipalNameMapping)PrincipalNameMappingParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ROLE_IDENTIFIERS: {
                target.setRoleAttributes((Set)RoleMappingParser.getInstance().parse(xmlEventReader));
                break;
            }
            case IDP: {
                target.setIdp((IDP)IdpParser.getInstance().parse(xmlEventReader));
            }
        }
    }
}

