/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import java.net.URI;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.elytron.ElytronHttpFacade;
import org.keycloak.adapters.saml.elytron.ElytronSamlAuthenticator;
import org.keycloak.adapters.saml.elytron.ElytronSamlEndpoint;
import org.keycloak.adapters.saml.elytron.KeycloakConfigurationServletListener;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;

class KeycloakHttpServerAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    static Logger LOGGER = Logger.getLogger(KeycloakHttpServerAuthenticationMechanism.class);
    static final String NAME = "KEYCLOAK-SAML";
    private final Map<String, ?> properties;
    private final CallbackHandler callbackHandler;
    private final SamlDeploymentContext deploymentContext;
    private final SessionIdMapper idMapper;
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*:");

    public KeycloakHttpServerAuthenticationMechanism(Map<String, ?> properties, CallbackHandler callbackHandler, SamlDeploymentContext deploymentContext, SessionIdMapper idMapper) {
        this.properties = properties;
        this.callbackHandler = callbackHandler;
        this.deploymentContext = deploymentContext;
        this.idMapper = idMapper;
    }

    public String getMechanismName() {
        return NAME;
    }

    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        LOGGER.debugf("Evaluating request for path [%s]", (Object)request.getRequestURI());
        SamlDeploymentContext deploymentContext = this.getDeploymentContext(request);
        if (deploymentContext == null) {
            LOGGER.debugf("Ignoring request for path [%s] from mechanism [%s]. No deployment context found.", (Object)request.getRequestURI(), (Object)this.getMechanismName());
            request.noAuthenticationInProgress();
            return;
        }
        ElytronHttpFacade httpFacade = new ElytronHttpFacade(request, this.idMapper, deploymentContext, this.callbackHandler);
        SamlDeployment deployment = httpFacade.getDeployment();
        if (!deployment.isConfigured()) {
            request.noAuthenticationInProgress();
            return;
        }
        if (httpFacade.getRequest().getRelativePath().contains(deployment.getLogoutPage())) {
            LOGGER.debugf("Ignoring request for [%s] and logout page [%s].", (Object)request.getRequestURI(), (Object)deployment.getLogoutPage());
            httpFacade.authenticationCompleteAnonymous();
            return;
        }
        SamlAuthenticator authenticator = httpFacade.getRequest().getRelativePath().endsWith("/saml") ? new ElytronSamlEndpoint(httpFacade, deployment) : new ElytronSamlAuthenticator(httpFacade, deployment, this.callbackHandler);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            httpFacade.authenticationComplete();
            return;
        }
        if (outcome == AuthOutcome.NOT_AUTHENTICATED) {
            httpFacade.noAuthenticationInProgress(null);
            return;
        }
        if (outcome == AuthOutcome.LOGGED_OUT) {
            if (deployment.getLogoutPage() != null) {
                this.redirectLogout(deployment, httpFacade);
            }
            httpFacade.authenticationInProgress();
            return;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            httpFacade.noAuthenticationInProgress(challenge);
            return;
        }
        if (outcome == AuthOutcome.FAILED) {
            httpFacade.authenticationFailed();
            return;
        }
        httpFacade.authenticationInProgress();
    }

    private SamlDeploymentContext getDeploymentContext(HttpServerRequest request) {
        if (this.deploymentContext == null) {
            return (SamlDeploymentContext)request.getScope(Scope.APPLICATION).getAttachment(KeycloakConfigurationServletListener.ADAPTER_DEPLOYMENT_CONTEXT_ATTRIBUTE);
        }
        return this.deploymentContext;
    }

    protected void redirectLogout(SamlDeployment deployment, ElytronHttpFacade exchange) {
        String page = deployment.getLogoutPage();
        KeycloakHttpServerAuthenticationMechanism.sendRedirect(exchange, page);
        exchange.getResponse().setStatus(302);
    }

    static void sendRedirect(ElytronHttpFacade exchange, String location) {
        if (location == null) {
            LOGGER.warn((Object)"Logout page not set.");
            exchange.getResponse().setStatus(302);
            return;
        }
        if (PROTOCOL_PATTERN.matcher(location).find()) {
            exchange.getResponse().setHeader("Location", location);
        } else {
            URI uri = exchange.getURI();
            String path = uri.getPath();
            String relativePath = exchange.getRequest().getRelativePath();
            String contextPath = path.substring(0, path.indexOf(relativePath));
            String loc = exchange.getURI().getScheme() + "://" + exchange.getURI().getHost() + ":" + exchange.getURI().getPort() + contextPath + location;
            exchange.getResponse().setHeader("Location", loc);
        }
    }
}

