/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RealmAdapter
implements RealmModel {
    protected CachedRealm cached;
    protected CacheRealmProvider cacheSession;
    protected RealmModel updated;
    protected RealmCache cache;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient Key codeSecretKey;
    protected volatile transient X509Certificate certificate;

    public RealmAdapter(CachedRealm cached, CacheRealmProvider cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRealmInvalidation(this.getId());
            this.updated = this.cacheSession.getDelegate().getRealm(this.getId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public String getId() {
        if (this.updated != null) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.updated != null) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public boolean isEnabled() {
        if (this.updated != null) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        if (this.updated != null) {
            return this.updated.getSslRequired();
        }
        return this.cached.getSslRequired();
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.getDelegateForUpdate();
        this.updated.setSslRequired(sslRequired);
    }

    public boolean isRegistrationAllowed() {
        if (this.updated != null) {
            return this.updated.isRegistrationAllowed();
        }
        return this.cached.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        if (this.updated != null) {
            return this.updated.isRegistrationEmailAsUsername();
        }
        return this.cached.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        if (this.updated != null) {
            return this.updated.isRememberMe();
        }
        return this.cached.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.getDelegateForUpdate();
        this.updated.setRememberMe(rememberMe);
    }

    public boolean isBruteForceProtected() {
        if (this.updated != null) {
            return this.updated.isBruteForceProtected();
        }
        return this.cached.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.getDelegateForUpdate();
        this.updated.setBruteForceProtected(value);
    }

    public int getMaxFailureWaitSeconds() {
        if (this.updated != null) {
            return this.updated.getMaxFailureWaitSeconds();
        }
        return this.cached.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        if (this.updated != null) {
            return this.updated.getWaitIncrementSeconds();
        }
        return this.cached.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setWaitIncrementSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        if (this.updated != null) {
            return this.updated.getMinimumQuickLoginWaitSeconds();
        }
        return this.cached.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMinimumQuickLoginWaitSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        if (this.updated != null) {
            return this.updated.getQuickLoginCheckMilliSeconds();
        }
        return this.cached.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.getDelegateForUpdate();
        this.updated.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        if (this.updated != null) {
            return this.updated.getMaxDeltaTimeSeconds();
        }
        return this.cached.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        if (this.updated != null) {
            return this.updated.getFailureFactor();
        }
        return this.cached.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.getDelegateForUpdate();
        this.updated.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        if (this.updated != null) {
            return this.updated.isVerifyEmail();
        }
        return this.cached.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.getDelegateForUpdate();
        this.updated.setVerifyEmail(verifyEmail);
    }

    public boolean isResetPasswordAllowed() {
        if (this.updated != null) {
            return this.updated.isResetPasswordAllowed();
        }
        return this.cached.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.getDelegateForUpdate();
        this.updated.setResetPasswordAllowed(resetPasswordAllowed);
    }

    public boolean isEditUsernameAllowed() {
        if (this.updated != null) {
            return this.updated.isEditUsernameAllowed();
        }
        return this.cached.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.getDelegateForUpdate();
        this.updated.setEditUsernameAllowed(editUsernameAllowed);
    }

    public boolean isRevokeRefreshToken() {
        if (this.updated != null) {
            return this.updated.isRevokeRefreshToken();
        }
        return this.cached.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.getDelegateForUpdate();
        this.updated.setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getSsoSessionIdleTimeout() {
        if (this.updated != null) {
            return this.updated.getSsoSessionIdleTimeout();
        }
        return this.cached.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        if (this.updated != null) {
            return this.updated.getSsoSessionMaxLifespan();
        }
        return this.cached.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionMaxLifespan(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        if (this.updated != null) {
            return this.updated.getOfflineSessionIdleTimeout();
        }
        return this.cached.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setOfflineSessionIdleTimeout(seconds);
    }

    public int getAccessTokenLifespan() {
        if (this.updated != null) {
            return this.updated.getAccessTokenLifespan();
        }
        return this.cached.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespan(seconds);
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        if (this.updated != null) {
            return this.updated.getAccessTokenLifespanForImplicitFlow();
        }
        return this.cached.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getAccessCodeLifespan() {
        if (this.updated != null) {
            return this.updated.getAccessCodeLifespan();
        }
        return this.cached.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespan(seconds);
    }

    public int getAccessCodeLifespanUserAction() {
        if (this.updated != null) {
            return this.updated.getAccessCodeLifespanUserAction();
        }
        return this.cached.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanUserAction(seconds);
    }

    public int getAccessCodeLifespanLogin() {
        if (this.updated != null) {
            return this.updated.getAccessCodeLifespanLogin();
        }
        return this.cached.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanLogin(seconds);
    }

    public String getPublicKeyPem() {
        if (this.updated != null) {
            return this.updated.getPublicKeyPem();
        }
        return this.cached.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.getDelegateForUpdate();
        this.updated.setPublicKeyPem(publicKeyPem);
    }

    public String getPrivateKeyPem() {
        if (this.updated != null) {
            return this.updated.getPrivateKeyPem();
        }
        return this.cached.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.getDelegateForUpdate();
        this.updated.setPrivateKeyPem(privateKeyPem);
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certPem);
    }

    public String getCertificatePem() {
        if (this.updated != null) {
            return this.updated.getCertificatePem();
        }
        return this.cached.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.getDelegateForUpdate();
        this.updated.setCertificatePem(certificate);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.updated != null ? this.updated.getCodeSecret() : this.cached.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.getDelegateForUpdate();
        this.updated.setCodeSecret(codeSecret);
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        LinkedList<RequiredCredentialModel> copy = new LinkedList<RequiredCredentialModel>();
        if (this.updated != null) {
            copy.addAll(this.updated.getRequiredCredentials());
        } else {
            copy.addAll(this.cached.getRequiredCredentials());
        }
        return copy;
    }

    public void addRequiredCredential(String cred) {
        this.getDelegateForUpdate();
        this.updated.addRequiredCredential(cred);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.updated != null) {
            return this.updated.getPasswordPolicy();
        }
        return this.cached.getPasswordPolicy();
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setPasswordPolicy(policy);
    }

    public OTPPolicy getOTPPolicy() {
        if (this.updated != null) {
            return this.updated.getOTPPolicy();
        }
        return this.cached.getOtpPolicy();
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setOTPPolicy(policy);
    }

    public RoleModel getRoleById(String id) {
        if (this.updated != null) {
            return this.updated.getRoleById(id);
        }
        return this.cacheSession.getRoleById(id, (RealmModel)this);
    }

    public List<GroupModel> getDefaultGroups() {
        LinkedList<GroupModel> defaultGroups = new LinkedList<GroupModel>();
        for (String id : this.cached.getDefaultGroups()) {
            defaultGroups.add(this.cacheSession.getGroupById(id, (RealmModel)this));
        }
        return defaultGroups;
    }

    public void addDefaultGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.addDefaultGroup(group);
    }

    public void removeDefaultGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.removeDefaultGroup(group);
    }

    public List<String> getDefaultRoles() {
        if (this.updated != null) {
            return this.updated.getDefaultRoles();
        }
        return this.cached.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        this.getDelegateForUpdate();
        this.updated.addDefaultRole(name);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        this.getDelegateForUpdate();
        this.updated.updateDefaultRoles(defaultRoles);
    }

    public Map<String, ClientModel> getClientNameMap() {
        if (this.updated != null) {
            return this.updated.getClientNameMap();
        }
        HashMap<String, ClientModel> map = new HashMap<String, ClientModel>();
        for (String id : this.cached.getClients().values()) {
            ClientModel model = this.cacheSession.getClientById(id, (RealmModel)this);
            if (model == null) {
                throw new IllegalStateException("Cached application not found: " + id);
            }
            map.put(model.getClientId(), model);
        }
        return map;
    }

    public List<ClientModel> getClients() {
        if (this.updated != null) {
            return this.updated.getClients();
        }
        LinkedList<ClientModel> apps = new LinkedList<ClientModel>();
        for (String id : this.cached.getClients().values()) {
            ClientModel model = this.cacheSession.getClientById(id, (RealmModel)this);
            if (model == null) {
                throw new IllegalStateException("Cached application not found: " + id);
            }
            apps.add(model);
        }
        return apps;
    }

    public ClientModel addClient(String name) {
        this.getDelegateForUpdate();
        ClientModel app = this.updated.addClient(name);
        this.cacheSession.registerApplicationInvalidation(app.getId());
        return app;
    }

    public ClientModel addClient(String id, String clientId) {
        this.getDelegateForUpdate();
        ClientModel app = this.updated.addClient(id, clientId);
        this.cacheSession.registerApplicationInvalidation(app.getId());
        return app;
    }

    public boolean removeClient(String id) {
        this.cacheSession.registerApplicationInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeClient(id);
    }

    public ClientModel getClientById(String id) {
        if (this.updated != null) {
            return this.updated.getClientById(id);
        }
        return this.cacheSession.getClientById(id, (RealmModel)this);
    }

    public ClientModel getClientByClientId(String clientId) {
        if (this.updated != null) {
            return this.updated.getClientByClientId(clientId);
        }
        String id = (String)this.cached.getClients().get(clientId);
        if (id == null) {
            return null;
        }
        return this.getClientById(id);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredCredentials(creds);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        if (this.updated != null) {
            return this.updated.getBrowserSecurityHeaders();
        }
        return this.cached.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.getDelegateForUpdate();
        this.updated.setBrowserSecurityHeaders(headers);
    }

    public Map<String, String> getSmtpConfig() {
        if (this.updated != null) {
            return this.updated.getSmtpConfig();
        }
        return this.cached.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.getDelegateForUpdate();
        this.updated.setSmtpConfig(smtpConfig);
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        if (this.updated != null) {
            return this.updated.getIdentityProviders();
        }
        return this.cached.getIdentityProviders();
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        this.getDelegateForUpdate();
        this.updated.addIdentityProvider(identityProvider);
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        this.getDelegateForUpdate();
        this.updated.updateIdentityProvider(identityProvider);
    }

    public void removeIdentityProviderByAlias(String alias) {
        this.getDelegateForUpdate();
        this.updated.removeIdentityProviderByAlias(alias);
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        if (this.updated != null) {
            return this.updated.getUserFederationProviders();
        }
        return this.cached.getUserFederationProviders();
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        this.getDelegateForUpdate();
        this.updated.setUserFederationProviders(providers);
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        this.getDelegateForUpdate();
        return this.updated.addUserFederationProvider(providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        this.getDelegateForUpdate();
        this.updated.removeUserFederationProvider(provider);
    }

    public void updateUserFederationProvider(UserFederationProviderModel provider) {
        this.getDelegateForUpdate();
        this.updated.updateUserFederationProvider(provider);
    }

    public String getLoginTheme() {
        if (this.updated != null) {
            return this.updated.getLoginTheme();
        }
        return this.cached.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setLoginTheme(name);
    }

    public String getAccountTheme() {
        if (this.updated != null) {
            return this.updated.getAccountTheme();
        }
        return this.cached.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAccountTheme(name);
    }

    public String getAdminTheme() {
        if (this.updated != null) {
            return this.updated.getAdminTheme();
        }
        return this.cached.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAdminTheme(name);
    }

    public String getEmailTheme() {
        if (this.updated != null) {
            return this.updated.getEmailTheme();
        }
        return this.cached.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setEmailTheme(name);
    }

    public int getNotBefore() {
        if (this.updated != null) {
            return this.updated.getNotBefore();
        }
        return this.cached.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updated.setNotBefore(notBefore);
    }

    public boolean removeRoleById(String id) {
        this.cacheSession.registerRoleInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeRoleById(id);
    }

    public boolean isEventsEnabled() {
        if (this.updated != null) {
            return this.updated.isEventsEnabled();
        }
        return this.cached.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        if (this.updated != null) {
            return this.updated.getEventsExpiration();
        }
        return this.cached.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.getDelegateForUpdate();
        this.updated.setEventsExpiration(expiration);
    }

    public Set<String> getEventsListeners() {
        if (this.updated != null) {
            return this.updated.getEventsListeners();
        }
        return this.cached.getEventsListeners();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.getDelegateForUpdate();
        this.updated.setEventsListeners(listeners);
    }

    public Set<String> getEnabledEventTypes() {
        if (this.updated != null) {
            return this.updated.getEnabledEventTypes();
        }
        return this.cached.getEnabledEventTypes();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.getDelegateForUpdate();
        this.updated.setEnabledEventTypes(enabledEventTypes);
    }

    public boolean isAdminEventsEnabled() {
        if (this.updated != null) {
            return this.updated.isAdminEventsEnabled();
        }
        return this.cached.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setAdminEventsEnabled(enabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        if (this.updated != null) {
            return this.updated.isAdminEventsDetailsEnabled();
        }
        return this.cached.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setAdminEventsDetailsEnabled(enabled);
    }

    public ClientModel getMasterAdminClient() {
        return this.cached.getMasterAdminClient() == null ? null : this.cacheSession.getRealm(Config.getAdminRealm()).getClientById(this.cached.getMasterAdminClient());
    }

    public void setMasterAdminClient(ClientModel client) {
        this.getDelegateForUpdate();
        this.updated.setMasterAdminClient(client);
    }

    public RoleModel getRole(String name) {
        if (this.updated != null) {
            return this.updated.getRole(name);
        }
        String id = (String)this.cached.getRealmRoles().get(name);
        if (id == null) {
            return null;
        }
        return this.cacheSession.getRoleById(id, (RealmModel)this);
    }

    public RoleModel addRole(String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public RoleModel addRole(String id, String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(id, name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public boolean removeRole(RoleModel role) {
        this.cacheSession.registerRoleInvalidation(role.getId());
        this.getDelegateForUpdate();
        return this.updated.removeRole(role);
    }

    public Set<RoleModel> getRoles() {
        if (this.updated != null) {
            return this.updated.getRoles();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getRealmRoles().values()) {
            RoleModel roleById = this.cacheSession.getRoleById(id, (RealmModel)this);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    public boolean isIdentityFederationEnabled() {
        if (this.updated != null) {
            return this.updated.isIdentityFederationEnabled();
        }
        return this.cached.isIdentityFederationEnabled();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isInternationalizationEnabled() {
        if (this.updated != null) {
            return this.updated.isInternationalizationEnabled();
        }
        return this.cached.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setInternationalizationEnabled(enabled);
    }

    public Set<String> getSupportedLocales() {
        if (this.updated != null) {
            return this.updated.getSupportedLocales();
        }
        return this.cached.getSupportedLocales();
    }

    public void setSupportedLocales(Set<String> locales) {
        this.getDelegateForUpdate();
        this.updated.setSupportedLocales(locales);
    }

    public String getDefaultLocale() {
        if (this.updated != null) {
            return this.updated.getDefaultLocale();
        }
        return this.cached.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.updated.setDefaultLocale(locale);
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        if (this.updated != null) {
            return this.updated.getIdentityProviderMappers();
        }
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (List models : this.cached.getIdentityProviderMappers().values()) {
            for (IdentityProviderMapperModel model : models) {
                mappings.add(model);
            }
        }
        return mappings;
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        if (this.updated != null) {
            return this.updated.getIdentityProviderMappersByAlias(brokerAlias);
        }
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        List list = this.cached.getIdentityProviderMappers().getList((Object)brokerAlias);
        for (IdentityProviderMapperModel entity : list) {
            mappings.add(entity);
        }
        return mappings;
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addIdentityProviderMapper(model);
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeIdentityProviderMapper(mapping);
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateIdentityProviderMapper(mapping);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        if (this.updated != null) {
            return this.updated.getIdentityProviderMapperById(id);
        }
        for (List models : this.cached.getIdentityProviderMappers().values()) {
            for (IdentityProviderMapperModel model : models) {
                if (!model.getId().equals(id)) continue;
                return model;
            }
        }
        return null;
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        if (this.updated != null) {
            return this.updated.getIdentityProviderMapperByName(alias, name);
        }
        List models = this.cached.getIdentityProviderMappers().getList((Object)alias);
        if (models == null) {
            return null;
        }
        for (IdentityProviderMapperModel model : models) {
            if (!model.getName().equals(name)) continue;
            return model;
        }
        return null;
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        if (this.updated != null) {
            return this.updated.getUserFederationMappers();
        }
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (List models : this.cached.getUserFederationMappers().values()) {
            for (UserFederationMapperModel model : models) {
                mappers.add(model);
            }
        }
        return mappers;
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        if (this.updated != null) {
            return this.updated.getUserFederationMappersByFederationProvider(federationProviderId);
        }
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        List list = this.cached.getUserFederationMappers().getList((Object)federationProviderId);
        for (UserFederationMapperModel entity : list) {
            mappers.add(entity);
        }
        return mappers;
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel mapper) {
        this.getDelegateForUpdate();
        return this.updated.addUserFederationMapper(mapper);
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        this.getDelegateForUpdate();
        this.updated.removeUserFederationMapper(mapper);
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        this.getDelegateForUpdate();
        this.updated.updateUserFederationMapper(mapper);
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        if (this.updated != null) {
            return this.updated.getUserFederationMapperById(id);
        }
        for (List models : this.cached.getUserFederationMappers().values()) {
            for (UserFederationMapperModel model : models) {
                if (!model.getId().equals(id)) continue;
                return model;
            }
        }
        return null;
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        if (this.updated != null) {
            return this.updated.getUserFederationMapperByName(federationProviderId, name);
        }
        List models = this.cached.getUserFederationMappers().getList((Object)federationProviderId);
        if (models == null) {
            return null;
        }
        for (UserFederationMapperModel model : models) {
            if (!model.getName().equals(name)) continue;
            return model;
        }
        return null;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        if (this.updated != null) {
            return this.updated.getBrowserFlow();
        }
        return this.cached.getBrowserFlow();
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setBrowserFlow(flow);
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        if (this.updated != null) {
            return this.updated.getRegistrationFlow();
        }
        return this.cached.getRegistrationFlow();
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationFlow(flow);
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        if (this.updated != null) {
            return this.updated.getDirectGrantFlow();
        }
        return this.cached.getDirectGrantFlow();
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setDirectGrantFlow(flow);
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        if (this.updated != null) {
            return this.updated.getResetCredentialsFlow();
        }
        return this.cached.getResetCredentialsFlow();
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setResetCredentialsFlow(flow);
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        if (this.updated != null) {
            return this.updated.getClientAuthenticationFlow();
        }
        return this.cached.getClientAuthenticationFlow();
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setClientAuthenticationFlow(flow);
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        if (this.updated != null) {
            return this.updated.getAuthenticationFlows();
        }
        ArrayList<AuthenticationFlowModel> models = new ArrayList<AuthenticationFlowModel>();
        models.addAll(this.cached.getAuthenticationFlows().values());
        return models;
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        for (AuthenticationFlowModel flow : this.getAuthenticationFlows()) {
            if (!flow.getAlias().equals(alias)) continue;
            return flow;
        }
        return null;
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        for (AuthenticatorConfigModel config : this.getAuthenticatorConfigs()) {
            if (!config.getAlias().equals(alias)) continue;
            return config;
        }
        return null;
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticationFlow(model);
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        if (this.updated != null) {
            return this.updated.getAuthenticationFlowById(id);
        }
        return (AuthenticationFlowModel)this.cached.getAuthenticationFlows().get(id);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticationFlow(model);
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticationFlow(model);
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        if (this.updated != null) {
            return this.updated.getAuthenticationExecutions(flowId);
        }
        return (List)this.cached.getAuthenticationExecutions().get((Object)flowId);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        if (this.updated != null) {
            return this.updated.getAuthenticationExecutionById(id);
        }
        return (AuthenticationExecutionModel)this.cached.getExecutionsById().get(id);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticatorExecution(model);
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticatorExecution(model);
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticatorExecution(model);
    }

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs() {
        if (this.updated != null) {
            return this.updated.getAuthenticatorConfigs();
        }
        ArrayList<AuthenticatorConfigModel> models = new ArrayList<AuthenticatorConfigModel>();
        models.addAll(this.cached.getAuthenticatorConfigs().values());
        return models;
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticatorConfig(model);
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticatorConfig(model);
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticatorConfig(model);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        if (this.updated != null) {
            return this.updated.getAuthenticatorConfigById(id);
        }
        return (AuthenticatorConfigModel)this.cached.getAuthenticatorConfigs().get(id);
    }

    public List<RequiredActionProviderModel> getRequiredActionProviders() {
        if (this.updated != null) {
            return this.updated.getRequiredActionProviders();
        }
        ArrayList<RequiredActionProviderModel> models = new ArrayList<RequiredActionProviderModel>();
        models.addAll(this.cached.getRequiredActionProviders().values());
        return models;
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        return this.updated.addRequiredActionProvider(model);
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredActionProvider(model);
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        this.updated.removeRequiredActionProvider(model);
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        if (this.updated != null) {
            return this.updated.getRequiredActionProviderById(id);
        }
        return (RequiredActionProviderModel)this.cached.getRequiredActionProviders().get(id);
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        if (this.updated != null) {
            return this.updated.getRequiredActionProviderByAlias(alias);
        }
        return (RequiredActionProviderModel)this.cached.getRequiredActionProvidersByAlias().get(alias);
    }

    public GroupModel getGroupById(String id) {
        if (this.updated != null) {
            return this.updated.getGroupById(id);
        }
        return this.cacheSession.getGroupById(id, (RealmModel)this);
    }

    public List<GroupModel> getGroups() {
        if (this.updated != null) {
            return this.updated.getGroups();
        }
        if (this.cached.getGroups().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<GroupModel> list = new LinkedList<GroupModel>();
        for (String id : this.cached.getGroups()) {
            GroupModel group = this.cacheSession.getGroupById(id, (RealmModel)this);
            if (group == null) continue;
            list.add(group);
        }
        return list;
    }

    public List<GroupModel> getTopLevelGroups() {
        List<GroupModel> all = this.getGroups();
        Iterator<GroupModel> it = all.iterator();
        while (it.hasNext()) {
            GroupModel group = it.next();
            if (group.getParent() == null) continue;
            it.remove();
        }
        return all;
    }

    public boolean removeGroup(GroupModel group) {
        this.getDelegateForUpdate();
        return this.updated.removeGroup(group);
    }

    public GroupModel createGroup(String name) {
        this.getDelegateForUpdate();
        return this.updated.createGroup(name);
    }

    public GroupModel createGroup(String id, String name) {
        this.getDelegateForUpdate();
        return this.updated.createGroup(id, name);
    }

    public void addTopLevelGroup(GroupModel subGroup) {
        this.getDelegateForUpdate();
        this.updated.addTopLevelGroup(subGroup);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.getDelegateForUpdate();
        this.updated.moveGroup(group, toParent);
    }

    public List<ClientTemplateModel> getClientTemplates() {
        if (this.updated != null) {
            return this.updated.getClientTemplates();
        }
        LinkedList<ClientTemplateModel> apps = new LinkedList<ClientTemplateModel>();
        for (String id : this.cached.getClientTemplates()) {
            ClientTemplateModel model = this.cacheSession.getClientTemplateById(id, (RealmModel)this);
            if (model == null) {
                throw new IllegalStateException("Cached clientemplate not found: " + id);
            }
            apps.add(model);
        }
        return apps;
    }

    public ClientTemplateModel addClientTemplate(String name) {
        this.getDelegateForUpdate();
        ClientTemplateModel app = this.updated.addClientTemplate(name);
        this.cacheSession.registerClientTemplateInvalidation(app.getId());
        return app;
    }

    public ClientTemplateModel addClientTemplate(String id, String name) {
        this.getDelegateForUpdate();
        ClientTemplateModel app = this.updated.addClientTemplate(id, name);
        this.cacheSession.registerClientTemplateInvalidation(app.getId());
        return app;
    }

    public boolean removeClientTemplate(String id) {
        this.cacheSession.registerClientTemplateInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeClientTemplate(id);
    }

    public ClientTemplateModel getClientTemplateById(String id) {
        if (this.updated != null) {
            return this.updated.getClientTemplateById(id);
        }
        return this.cacheSession.getClientTemplateById(id, (RealmModel)this);
    }
}

