/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class HardcodedRoleMapper
extends AbstractIdentityProviderMapper {
    public static final String ROLE = "role";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String[] COMPATIBLE_PROVIDERS;
    public static final String PROVIDER_ID = "oidc-hardcoded-role-idp-mapper";

    public static String[] parseRole(String role) {
        int scopeIndex = role.lastIndexOf(46);
        if (scopeIndex > -1) {
            String appName = role.substring(0, scopeIndex);
            role = role.substring(scopeIndex + 1);
            String[] rtn = new String[]{appName, role};
            return rtn;
        }
        String[] rtn = new String[]{null, role};
        return rtn;
    }

    public static RoleModel getRoleFromString(RealmModel realm, String roleName) {
        String[] parsedRole = HardcodedRoleMapper.parseRole(roleName);
        RoleModel role = null;
        if (parsedRole[0] == null) {
            role = realm.getRole(parsedRole[1]);
        } else {
            ClientModel client = realm.getClientByClientId(parsedRole[0]);
            role = client.getRole(parsedRole[1]);
        }
        return role;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getDisplayCategory() {
        return "Role Importer";
    }

    @Override
    public String getDisplayType() {
        return "Hardcoded Role";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    @Override
    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get(ROLE);
        RoleModel role = HardcodedRoleMapper.getRoleFromString(realm, roleName);
        if (role == null) {
            throw new IdentityBrokerException("Unable to find role: " + roleName);
        }
        user.grantRole(role);
    }

    @Override
    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public String getHelpText() {
        return "When user is imported from provider, hardcode a role mapping for it.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ROLE);
        property.setLabel("Role");
        property.setHelpText("Role to grant to user.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        property.setType("Role");
        configProperties.add(property);
        COMPATIBLE_PROVIDERS = new String[]{"*"};
    }
}

